/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client;

import infra.beans.factory.DisposableBean;
import infra.beans.factory.InitializingBean;
import infra.context.ApplicationContext;
import infra.context.ApplicationContextAware;
import infra.context.SmartLifecycle;
import infra.lang.Assert;
import infra.lang.Nullable;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Supplier;
import reactor.netty.http.HttpResources;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;

public class ReactorResourceFactory
implements ApplicationContextAware,
InitializingBean,
DisposableBean,
SmartLifecycle {
    private boolean useGlobalResources = true;
    @Nullable
    private LoopResources loopResources;
    @Nullable
    private ConnectionProvider connectionProvider;
    @Nullable
    private Consumer<HttpResources> globalResourcesConsumer;
    private Supplier<LoopResources> loopResourcesSupplier = () -> LoopResources.create((String)"reactive-http");
    private Supplier<ConnectionProvider> connectionProviderSupplier = () -> ConnectionProvider.create((String)"reactive", (int)500);
    private boolean manageLoopResources = false;
    private boolean manageConnectionProvider = false;
    private Duration shutdownTimeout = Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_TIMEOUT);
    private Duration shutdownQuietPeriod = Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_QUIET_PERIOD);
    private volatile boolean running;
    private final Object lifecycleMonitor = new Object();
    @Nullable
    private ApplicationContext applicationContext;

    public void setUseGlobalResources(boolean useGlobalResources) {
        this.useGlobalResources = useGlobalResources;
    }

    public boolean isUseGlobalResources() {
        return this.useGlobalResources;
    }

    public void addGlobalResourcesConsumer(Consumer<HttpResources> consumer) {
        this.useGlobalResources = true;
        this.globalResourcesConsumer = this.globalResourcesConsumer != null ? this.globalResourcesConsumer.andThen(consumer) : consumer;
    }

    public void setConnectionProviderSupplier(Supplier<ConnectionProvider> supplier) {
        this.connectionProviderSupplier = supplier;
    }

    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public ConnectionProvider getConnectionProvider() {
        ConnectionProvider connectionProvider;
        if (this.connectionProvider == null) {
            this.start();
        }
        Assert.state(((connectionProvider = this.connectionProvider) != null ? 1 : 0) != 0, (String)"ConnectionProvider not initialized");
        return connectionProvider;
    }

    public void setLoopResourcesSupplier(Supplier<LoopResources> supplier) {
        this.loopResourcesSupplier = supplier;
    }

    public void setLoopResources(LoopResources loopResources) {
        this.loopResources = loopResources;
    }

    public LoopResources getLoopResources() {
        LoopResources loopResources;
        if (this.loopResources == null) {
            this.start();
        }
        Assert.state(((loopResources = this.loopResources) != null ? 1 : 0) != 0, (String)"LoopResources not initialized");
        return loopResources;
    }

    public void setShutdownQuietPeriod(Duration shutdownQuietPeriod) {
        Assert.notNull((Object)shutdownQuietPeriod, (String)"shutdownQuietPeriod should not be null");
        this.shutdownQuietPeriod = shutdownQuietPeriod;
    }

    public void setShutdownTimeout(Duration shutdownTimeout) {
        Assert.notNull((Object)shutdownTimeout, (String)"shutdownTimeout should not be null");
        this.shutdownTimeout = shutdownTimeout;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        if (this.applicationContext == null) {
            this.start();
        }
    }

    public void destroy() {
        if (this.applicationContext == null) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.running) {
                if (this.useGlobalResources) {
                    Assert.isTrue((this.loopResources == null && this.connectionProvider == null ? 1 : 0) != 0, (String)"'useGlobalResources' is mutually exclusive with explicitly configured resources");
                    HttpResources httpResources = HttpResources.get();
                    if (this.globalResourcesConsumer != null) {
                        this.globalResourcesConsumer.accept(httpResources);
                    }
                    this.connectionProvider = httpResources;
                    this.loopResources = httpResources;
                } else {
                    if (this.loopResources == null) {
                        this.manageLoopResources = true;
                        this.loopResources = this.loopResourcesSupplier.get();
                    }
                    if (this.connectionProvider == null) {
                        this.manageConnectionProvider = true;
                        this.connectionProvider = this.connectionProviderSupplier.get();
                    }
                }
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running) {
                if (this.useGlobalResources) {
                    HttpResources.disposeLoopsAndConnectionsLater((Duration)this.shutdownQuietPeriod, (Duration)this.shutdownTimeout).block();
                    this.connectionProvider = null;
                    this.loopResources = null;
                } else {
                    try {
                        ConnectionProvider provider = this.connectionProvider;
                        if (provider != null && this.manageConnectionProvider) {
                            this.connectionProvider = null;
                            provider.disposeLater().block();
                        }
                    }
                    catch (Throwable provider) {
                        // empty catch block
                    }
                    try {
                        LoopResources resources = this.loopResources;
                        if (resources != null && this.manageLoopResources) {
                            this.loopResources = null;
                            resources.disposeLater(this.shutdownQuietPeriod, this.shutdownTimeout).block();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.running = false;
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 0;
    }
}

