/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client;

import infra.http.HttpHeaders;
import infra.http.HttpStatusCode;
import infra.http.client.ClientHttpResponse;
import infra.http.client.ReactorClientHttpRequest;
import infra.http.client.SubscriberInputStream;
import infra.http.support.Netty4HttpHeaders;
import infra.lang.Nullable;
import infra.util.StreamUtils;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import org.reactivestreams.FlowAdapters;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClientResponse;

final class ReactorClientHttpResponse
implements ClientHttpResponse,
Function<ByteBuf, byte[]> {
    private final HttpClientResponse response;
    private final Connection connection;
    private final HttpHeaders headers;
    @Nullable
    private volatile InputStream body;

    public ReactorClientHttpResponse(HttpClientResponse response, Connection connection) {
        this.response = response;
        this.connection = connection;
        this.headers = new Netty4HttpHeaders(response.responseHeaders()).asReadOnly();
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.valueOf(this.response.status().code());
    }

    @Override
    public String getStatusText() {
        return this.response.status().reasonPhrase();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public byte[] apply(ByteBuf byteBuf) {
        byte[] bytes = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(bytes);
        byteBuf.release();
        return bytes;
    }

    @Override
    public InputStream getBody() throws IOException {
        InputStream body = this.body;
        if (body != null) {
            return body;
        }
        try {
            SubscriberInputStream<ByteBuf> sis = new SubscriberInputStream<ByteBuf>(this, ReferenceCounted::release, 16);
            this.connection.inbound().receive().retain().subscribe(FlowAdapters.toSubscriber(sis));
            this.body = sis;
            return sis;
        }
        catch (RuntimeException ex) {
            throw ReactorClientHttpRequest.convertException(ex);
        }
    }

    @Override
    public void close() {
        try {
            InputStream body = this.getBody();
            StreamUtils.drain((InputStream)body);
            body.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

