/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client;

import infra.context.SmartLifecycle;
import infra.http.HttpMethod;
import infra.http.client.ClientHttpRequest;
import infra.http.client.ClientHttpRequestFactory;
import infra.http.client.ReactorClientHttpRequest;
import infra.http.client.ReactorResourceFactory;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import io.netty.channel.ChannelOption;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.function.Function;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

public class ReactorClientHttpRequestFactory
implements ClientHttpRequestFactory,
SmartLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(ReactorClientHttpRequestFactory.class);
    private static final Function<HttpClient, HttpClient> defaultInitializer = client -> client.compress(true).responseTimeout(Duration.ofSeconds(10L));
    @Nullable
    private final ReactorResourceFactory resourceFactory;
    @Nullable
    private final Function<HttpClient, HttpClient> mapper;
    @Nullable
    private Integer connectTimeout;
    @Nullable
    private Duration readTimeout;
    @Nullable
    private Duration exchangeTimeout;
    @Nullable
    private volatile HttpClient httpClient;
    private final Object lifecycleMonitor = new Object();

    public ReactorClientHttpRequestFactory() {
        this(defaultInitializer.apply(HttpClient.create()));
    }

    public ReactorClientHttpRequestFactory(HttpClient client) {
        Assert.notNull((Object)client, (String)"HttpClient is required");
        this.resourceFactory = null;
        this.mapper = null;
        this.httpClient = client;
    }

    public ReactorClientHttpRequestFactory(ReactorResourceFactory resourceFactory, Function<HttpClient, HttpClient> mapper) {
        this.resourceFactory = resourceFactory;
        this.mapper = mapper;
        if (resourceFactory.isRunning()) {
            this.httpClient = this.createHttpClient(resourceFactory, mapper);
        }
    }

    private HttpClient createHttpClient(ReactorResourceFactory factory, Function<HttpClient, HttpClient> mapper) {
        HttpClient client = HttpClient.create((ConnectionProvider)factory.getConnectionProvider());
        client = defaultInitializer.andThen(mapper).apply(client);
        client = (HttpClient)client.runOn(factory.getLoopResources());
        if (this.connectTimeout != null) {
            client = (HttpClient)client.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeout);
        }
        if (this.readTimeout != null) {
            client = client.responseTimeout(this.readTimeout);
        }
        return client;
    }

    public void setConnectTimeout(int connectTimeout) {
        Assert.isTrue((connectTimeout >= 0 ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.connectTimeout = connectTimeout;
        HttpClient httpClient = this.httpClient;
        if (httpClient != null) {
            this.httpClient = (HttpClient)httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeout);
        }
    }

    public void setConnectTimeout(Duration connectTimeout) {
        Assert.notNull((Object)connectTimeout, (String)"ConnectTimeout is required");
        this.setConnectTimeout((int)connectTimeout.toMillis());
    }

    public void setReadTimeout(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"ReadTimeout is required");
        Assert.isTrue((timeout.toMillis() > 0L ? 1 : 0) != 0, (String)"Timeout must be a positive value");
        this.readTimeout = timeout;
        HttpClient httpClient = this.httpClient;
        if (httpClient != null) {
            this.httpClient = httpClient.responseTimeout(timeout);
        }
    }

    public void setReadTimeout(long readTimeout) {
        this.setReadTimeout(Duration.ofMillis(readTimeout));
    }

    public void setExchangeTimeout(long exchangeTimeout) {
        Assert.isTrue((exchangeTimeout > 0L ? 1 : 0) != 0, (String)"Timeout must be a positive value");
        this.setExchangeTimeout(Duration.ofMillis(exchangeTimeout));
    }

    public void setExchangeTimeout(Duration exchangeTimeout) {
        Assert.notNull((Object)exchangeTimeout, (String)"ExchangeTimeout is required");
        this.exchangeTimeout = exchangeTimeout;
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        HttpClient client = this.httpClient;
        if (client == null) {
            Assert.state((this.resourceFactory != null && this.mapper != null ? 1 : 0) != 0, (String)"Expected HttpClient or ResourceFactory and mapper");
            client = this.createHttpClient(this.resourceFactory, this.mapper);
        }
        return new ReactorClientHttpRequest(client, httpMethod, uri, this.exchangeTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.resourceFactory != null && this.mapper != null) {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                if (this.httpClient == null) {
                    this.httpClient = this.createHttpClient(this.resourceFactory, this.mapper);
                }
            }
        } else {
            logger.warn("Restarting a ReactorClientHttpRequestFactory bean is only supported with externally managed Reactor Netty resources");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.resourceFactory != null && this.mapper != null) {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                this.httpClient = null;
            }
        }
    }

    public boolean isRunning() {
        return this.httpClient != null;
    }

    public int getPhase() {
        return 1;
    }
}

