/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client;

import infra.http.HttpHeaders;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.client.ClientHttpResponse;
import infra.lang.Nullable;
import infra.util.LinkedCaseInsensitiveMap;
import infra.util.MultiValueMap;
import infra.util.MultiValueMapAdapter;
import infra.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class JdkClientHttpResponse
implements ClientHttpResponse {
    private final HttpResponse<InputStream> response;
    private final HttpHeaders headers;
    private final InputStream body;

    public JdkClientHttpResponse(HttpResponse<InputStream> response) {
        this(response, response.body());
    }

    public JdkClientHttpResponse(HttpResponse<InputStream> response, @Nullable InputStream body) {
        this.response = response;
        this.headers = JdkClientHttpResponse.adaptHeaders(response);
        this.body = body != null ? body : InputStream.nullInputStream();
    }

    private static HttpHeaders adaptHeaders(HttpResponse<?> response) {
        Map<String, List<String>> rawHeaders = response.headers().map();
        LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap(rawHeaders.size(), Locale.ROOT);
        MultiValueMapAdapter multiValueMap = MultiValueMap.forAdaption((Map)map);
        multiValueMap.putAll(rawHeaders);
        return HttpHeaders.readOnlyHttpHeaders((MultiValueMap<String, String>)multiValueMap);
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.valueOf(this.response.statusCode());
    }

    @Override
    public String getStatusText() {
        HttpStatusCode httpStatusCode = this.getStatusCode();
        if (httpStatusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)httpStatusCode;
            return status.getReasonPhrase();
        }
        return "";
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public InputStream getBody() throws IOException {
        return this.body;
    }

    @Override
    public void close() {
        try (InputStream inputStream = this.body;){
            StreamUtils.drain((InputStream)this.body);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

