/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client;

import infra.core.task.SimpleAsyncTaskExecutor;
import infra.http.HttpMethod;
import infra.http.client.ClientHttpRequest;
import infra.http.client.ClientHttpRequestFactory;
import infra.http.client.JdkClientHttpRequest;
import infra.lang.Assert;
import infra.lang.Nullable;
import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.Executor;

public class JdkClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private final HttpClient httpClient;
    private final Executor executor;
    @Nullable
    private Duration readTimeout;

    public JdkClientHttpRequestFactory() {
        this(HttpClient.newHttpClient());
    }

    public JdkClientHttpRequestFactory(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"HttpClient is required");
        this.httpClient = httpClient;
        this.executor = httpClient.executor().orElseGet(SimpleAsyncTaskExecutor::new);
    }

    public JdkClientHttpRequestFactory(HttpClient httpClient, Executor executor) {
        Assert.notNull((Object)httpClient, (String)"HttpClient is required");
        Assert.notNull((Object)executor, (String)"Executor is required");
        this.httpClient = httpClient;
        this.executor = executor;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = Duration.ofMillis(readTimeout);
    }

    public void setReadTimeout(Duration readTimeout) {
        Assert.notNull((Object)readTimeout, (String)"ReadTimeout is required");
        this.readTimeout = readTimeout;
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) {
        return new JdkClientHttpRequest(this.httpClient, uri, httpMethod, this.executor, this.readTimeout);
    }
}

