/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client;

import infra.http.HttpHeaders;
import infra.http.HttpStatusCode;
import infra.http.client.ClientHttpResponse;
import infra.lang.Nullable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;

final class HttpComponentsClientHttpResponse
implements ClientHttpResponse {
    private final ClassicHttpResponse httpResponse;
    @Nullable
    private HttpHeaders headers;

    HttpComponentsClientHttpResponse(ClassicHttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.valueOf(this.httpResponse.getCode());
    }

    @Override
    public String getStatusText() {
        return this.httpResponse.getReasonPhrase();
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = HttpHeaders.forWritable();
            for (Header header : this.httpResponse.getHeaders()) {
                this.headers.add(header.getName(), header.getValue());
            }
        }
        return this.headers;
    }

    @Override
    public InputStream getBody() throws IOException {
        HttpEntity entity = this.httpResponse.getEntity();
        return entity != null ? entity.getContent() : InputStream.nullInputStream();
    }

    @Override
    public void close() {
        try {
            try {
                EntityUtils.consume((HttpEntity)this.httpResponse.getEntity());
            }
            finally {
                this.httpResponse.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

