/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client;

import infra.beans.factory.DisposableBean;
import infra.http.HttpMethod;
import infra.http.client.ClientHttpRequest;
import infra.http.client.ClientHttpRequestFactory;
import infra.http.client.HttpComponentsClientHttpRequest;
import infra.lang.Assert;
import infra.lang.Nullable;
import java.io.Closeable;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;

public class HttpComponentsClientHttpRequestFactory
implements ClientHttpRequestFactory,
DisposableBean {
    private HttpClient httpClient;
    private long connectTimeout = -1L;
    private long connectionRequestTimeout = -1L;
    @Nullable
    private BiFunction<HttpMethod, URI, HttpContext> httpContextFactory;
    private long readTimeout = -1L;

    public HttpComponentsClientHttpRequestFactory() {
        this.httpClient = HttpClients.createSystem();
    }

    public HttpComponentsClientHttpRequestFactory(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"HttpClient is required");
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setConnectTimeout(int connectTimeout) {
        Assert.isTrue((connectTimeout >= 0 ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.connectTimeout = connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        Assert.notNull((Object)connectTimeout, (String)"ConnectTimeout is required");
        Assert.isTrue((!connectTimeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.connectTimeout = connectTimeout.toMillis();
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        Assert.isTrue((connectionRequestTimeout >= 0 ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(Duration connectionRequestTimeout) {
        Assert.notNull((Object)connectionRequestTimeout, (String)"ConnectionRequestTimeout is required");
        Assert.isTrue((!connectionRequestTimeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.connectionRequestTimeout = connectionRequestTimeout.toMillis();
    }

    public void setReadTimeout(int readTimeout) {
        Assert.isTrue((readTimeout >= 0 ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.readTimeout = readTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        Assert.notNull((Object)readTimeout, (String)"ReadTimeout is required");
        Assert.isTrue((!readTimeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.readTimeout = readTimeout.toMillis();
    }

    public void setHttpContextFactory(BiFunction<HttpMethod, URI, HttpContext> httpContextFactory) {
        this.httpContextFactory = httpContextFactory;
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) {
        HttpClientContext clientContext;
        HttpClient client = this.getHttpClient();
        ClassicHttpRequest httpRequest = this.createHttpUriRequest(httpMethod, uri);
        this.postProcessHttpRequest(httpRequest);
        HttpContext context = this.createHttpContext(httpMethod, uri);
        if (context == null) {
            context = HttpClientContext.create();
        }
        if (!(context instanceof HttpClientContext && (clientContext = (HttpClientContext)context).getRequestConfig() != null || context.getAttribute("http.request-config") != null)) {
            RequestConfig config = null;
            if (httpRequest instanceof Configurable) {
                Configurable configurable = (Configurable)httpRequest;
                config = configurable.getConfig();
            }
            if (config == null) {
                config = this.createRequestConfig(client);
            }
            if (config != null) {
                if (context instanceof HttpClientContext) {
                    HttpClientContext clientContext2 = (HttpClientContext)context;
                    clientContext2.setRequestConfig(config);
                }
                context.setAttribute("http.request-config", (Object)config);
            }
        }
        return new HttpComponentsClientHttpRequest(client, httpRequest, context);
    }

    @Nullable
    protected RequestConfig createRequestConfig(Object client) {
        if (client instanceof Configurable) {
            Configurable configurableClient = (Configurable)client;
            RequestConfig clientRequestConfig = configurableClient.getConfig();
            return this.mergeRequestConfig(clientRequestConfig);
        }
        return this.mergeRequestConfig(RequestConfig.DEFAULT);
    }

    protected RequestConfig mergeRequestConfig(RequestConfig clientConfig) {
        if (this.connectTimeout == -1L && this.connectionRequestTimeout == -1L && this.readTimeout == -1L) {
            return clientConfig;
        }
        RequestConfig.Builder builder = RequestConfig.copy((RequestConfig)clientConfig);
        if (this.connectTimeout >= 0L) {
            builder.setConnectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS);
        }
        if (this.connectionRequestTimeout >= 0L) {
            builder.setConnectionRequestTimeout(this.connectionRequestTimeout, TimeUnit.MILLISECONDS);
        }
        if (this.readTimeout >= 0L) {
            builder.setResponseTimeout(this.readTimeout, TimeUnit.MILLISECONDS);
        }
        return builder.build();
    }

    protected ClassicHttpRequest createHttpUriRequest(HttpMethod httpMethod, URI uri) {
        return switch (httpMethod) {
            case HttpMethod.GET -> new HttpGet(uri);
            case HttpMethod.PUT -> new HttpPut(uri);
            case HttpMethod.HEAD -> new HttpHead(uri);
            case HttpMethod.POST -> new HttpPost(uri);
            case HttpMethod.TRACE -> new HttpTrace(uri);
            case HttpMethod.PATCH -> new HttpPatch(uri);
            case HttpMethod.DELETE -> new HttpDelete(uri);
            case HttpMethod.OPTIONS -> new HttpOptions(uri);
            default -> throw new UnsupportedOperationException("Unsupported httpMethod '%s'".formatted(new Object[]{httpMethod}));
        };
    }

    protected void postProcessHttpRequest(ClassicHttpRequest request) {
    }

    @Nullable
    protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
        return this.httpContextFactory != null ? this.httpContextFactory.apply(httpMethod, uri) : null;
    }

    public void destroy() throws Exception {
        HttpClient httpClient = this.getHttpClient();
        if (httpClient instanceof Closeable) {
            Closeable closeable = (Closeable)httpClient;
            closeable.close();
        }
    }
}

