/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client;

import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.StreamingHttpOutputMessage;
import infra.http.client.AbstractStreamingClientHttpRequest;
import infra.http.client.ClientHttpResponse;
import infra.http.client.HttpComponentsClientHttpResponse;
import infra.lang.Nullable;
import infra.lang.VisibleForTesting;
import infra.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.io.entity.NullEntity;
import org.apache.hc.core5.http.protocol.HttpContext;

final class HttpComponentsClientHttpRequest
extends AbstractStreamingClientHttpRequest {
    private final HttpClient httpClient;
    private final HttpContext httpContext;
    private final ClassicHttpRequest httpRequest;
    private final HttpMethod method;

    HttpComponentsClientHttpRequest(HttpClient client, ClassicHttpRequest request, HttpContext context) {
        this.httpClient = client;
        this.httpRequest = request;
        this.httpContext = context;
        this.method = HttpMethod.valueOf(this.httpRequest.getMethod());
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public URI getURI() {
        try {
            return this.httpRequest.getUri();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    @VisibleForTesting
    HttpContext getHttpContext() {
        return this.httpContext;
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body) throws IOException {
        HttpComponentsClientHttpRequest.addHeaders(this.httpRequest, headers);
        if (body != null) {
            this.httpRequest.setEntity((HttpEntity)new BodyEntity(headers, body));
        } else if (!Method.isSafe((String)this.httpRequest.getMethod())) {
            this.httpRequest.setEntity((HttpEntity)NullEntity.INSTANCE);
        }
        ClassicHttpResponse httpResponse = this.httpClient.executeOpen(null, this.httpRequest, this.httpContext);
        return new HttpComponentsClientHttpResponse(httpResponse);
    }

    static void addHeaders(ClassicHttpRequest httpRequest, HttpHeaders headers) {
        for (Map.Entry entry : headers.entrySet()) {
            String headerName = (String)entry.getKey();
            if ("Cookie".equalsIgnoreCase(headerName)) {
                String headerValue = StringUtils.collectionToDelimitedString((Collection)((Collection)entry.getValue()), (String)"; ");
                httpRequest.addHeader(headerName, (Object)headerValue);
                continue;
            }
            if ("Content-Length".equalsIgnoreCase(headerName) || "Transfer-Encoding".equalsIgnoreCase(headerName)) continue;
            for (String headerValue : (List)entry.getValue()) {
                httpRequest.addHeader(headerName, (Object)headerValue);
            }
        }
    }

    private static class BodyEntity
    implements HttpEntity {
        private final HttpHeaders headers;
        private final StreamingHttpOutputMessage.Body body;

        public BodyEntity(HttpHeaders headers, StreamingHttpOutputMessage.Body body) {
            this.headers = headers;
            this.body = body;
        }

        public long getContentLength() {
            return this.headers.getContentLength();
        }

        @Nullable
        public String getContentType() {
            return this.headers.getFirst("Content-Type");
        }

        public InputStream getContent() {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream outStream) throws IOException {
            this.body.writeTo(outStream);
        }

        public boolean isRepeatable() {
            return this.body.repeatable();
        }

        public boolean isStreaming() {
            return false;
        }

        @Nullable
        public Supplier<List<? extends Header>> getTrailers() {
            return null;
        }

        @Nullable
        public String getContentEncoding() {
            return this.headers.getFirst("Content-Encoding");
        }

        public boolean isChunked() {
            return false;
        }

        @Nullable
        public Set<String> getTrailerNames() {
            return null;
        }

        public void close() {
        }
    }
}

