/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client;

import infra.http.client.ClientHttpResponse;
import infra.http.client.ClientHttpResponseDecorator;
import infra.lang.Nullable;
import infra.util.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

final class BufferingClientHttpResponseWrapper
extends ClientHttpResponseDecorator {
    @Nullable
    private byte[] body;

    BufferingClientHttpResponseWrapper(ClientHttpResponse response) {
        super(response);
    }

    @Override
    public InputStream getBody() throws IOException {
        if (this.body == null) {
            this.body = StreamUtils.copyToByteArray((InputStream)this.delegate.getBody());
        }
        return new ByteArrayInputStream(this.body);
    }
}

