/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client;

import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.StreamingHttpOutputMessage;
import infra.http.client.AbstractBufferingClientHttpRequest;
import infra.http.client.BufferingClientHttpResponseWrapper;
import infra.http.client.ClientHttpRequest;
import infra.http.client.ClientHttpResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Map;

final class BufferingClientHttpRequestWrapper
extends AbstractBufferingClientHttpRequest {
    private final ClientHttpRequest request;

    BufferingClientHttpRequestWrapper(ClientHttpRequest request) {
        this.request = request;
    }

    @Override
    public HttpMethod getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getMethodValue() {
        return this.request.getMethodValue();
    }

    @Override
    public URI getURI() {
        return this.request.getURI();
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, byte[] bufferedOutput) throws IOException {
        this.request.getHeaders().putAll((Map)((Object)headers));
        if (bufferedOutput.length > 0) {
            StreamingHttpOutputMessage.writeBody(this.request, bufferedOutput);
        }
        ClientHttpResponse response = this.request.execute();
        return new BufferingClientHttpResponseWrapper(response);
    }
}

