/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client;

import infra.http.HttpHeaders;
import infra.http.StreamingHttpOutputMessage;
import infra.http.client.AbstractClientHttpRequest;
import infra.http.client.ClientHttpResponse;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.FastByteArrayOutputStream;
import infra.util.concurrent.Future;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Executor;

abstract class AbstractStreamingClientHttpRequest
extends AbstractClientHttpRequest
implements StreamingHttpOutputMessage {
    @Nullable
    private StreamingHttpOutputMessage.Body body;
    @Nullable
    private FastByteArrayOutputStream bodyStream;

    AbstractStreamingClientHttpRequest() {
    }

    @Override
    protected final OutputStream getBodyInternal(HttpHeaders headers) {
        Assert.state((this.body == null ? 1 : 0) != 0, (String)"Invoke either getBody or setBody; not both");
        if (this.bodyStream == null) {
            this.bodyStream = new FastByteArrayOutputStream(1024);
        }
        return this.bodyStream;
    }

    @Override
    public final void setBody(StreamingHttpOutputMessage.Body body) {
        Assert.notNull((Object)body, (String)"Body is required");
        this.assertNotExecuted();
        Assert.state((this.bodyStream == null ? 1 : 0) != 0, (String)"Invoke either getBody or setBody; not both");
        this.body = body;
    }

    @Override
    protected final ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        if (this.body == null && this.bodyStream != null) {
            this.body = outputStream -> this.bodyStream.writeTo(outputStream);
        }
        return this.executeInternal(headers, this.body);
    }

    @Override
    protected final Future<ClientHttpResponse> asyncInternal(HttpHeaders headers, @Nullable Executor executor) {
        if (this.body == null && this.bodyStream != null) {
            this.body = outputStream -> this.bodyStream.writeTo(outputStream);
        }
        return this.asyncInternal(headers, this.body, executor);
    }

    protected abstract ClientHttpResponse executeInternal(HttpHeaders var1, @Nullable StreamingHttpOutputMessage.Body var2) throws IOException;

    protected Future<ClientHttpResponse> asyncInternal(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body, @Nullable Executor executor) {
        return Future.run(() -> this.executeInternal(headers, body), (Executor)executor);
    }
}

