/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client;

import infra.http.AbstractHttpRequest;
import infra.http.HttpHeaders;
import infra.http.client.ClientHttpRequest;
import infra.http.client.ClientHttpResponse;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.concurrent.Future;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Executor;

public abstract class AbstractClientHttpRequest
extends AbstractHttpRequest
implements ClientHttpRequest {
    private final HttpHeaders headers = HttpHeaders.forWritable();
    private boolean executed = false;
    @Nullable
    private HttpHeaders readOnlyHeaders;

    @Override
    public final HttpHeaders getHeaders() {
        if (this.readOnlyHeaders != null) {
            return this.readOnlyHeaders;
        }
        if (this.executed) {
            this.readOnlyHeaders = this.headers.asReadOnly();
            return this.readOnlyHeaders;
        }
        return this.headers;
    }

    @Override
    public final OutputStream getBody() throws IOException {
        this.assertNotExecuted();
        return this.getBodyInternal(this.headers);
    }

    @Override
    public final ClientHttpResponse execute() throws IOException {
        this.assertNotExecuted();
        ClientHttpResponse result = this.executeInternal(this.headers);
        this.executed = true;
        return result;
    }

    @Override
    public final Future<ClientHttpResponse> async(@Nullable Executor executor) {
        this.assertNotExecuted();
        this.executed = true;
        return this.asyncInternal(this.headers, executor);
    }

    protected void assertNotExecuted() {
        Assert.state((!this.executed ? 1 : 0) != 0, (String)"ClientHttpRequest already executed");
    }

    protected abstract OutputStream getBodyInternal(HttpHeaders var1) throws IOException;

    protected abstract ClientHttpResponse executeInternal(HttpHeaders var1) throws IOException;

    protected Future<ClientHttpResponse> asyncInternal(HttpHeaders headers, @Nullable Executor executor) {
        return Future.run(() -> this.executeInternal(headers), (Executor)executor);
    }
}

