/*
 * Decompiled with CFR 0.152.
 */
package infra.http.client;

import infra.http.HttpHeaders;
import infra.http.client.AbstractClientHttpRequest;
import infra.http.client.ClientHttpResponse;
import infra.util.FastByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractBufferingClientHttpRequest
extends AbstractClientHttpRequest {
    private final FastByteArrayOutputStream bufferedOutput = new FastByteArrayOutputStream(1024);

    @Override
    protected OutputStream getBodyInternal(HttpHeaders headers) {
        return this.bufferedOutput;
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        byte[] bytes = this.bufferedOutput.toByteArrayUnsafe();
        if (headers.getContentLength() < 0L) {
            headers.setContentLength(bytes.length);
        }
        ClientHttpResponse result = this.executeInternal(headers, bytes);
        this.bufferedOutput.reset();
        return result;
    }

    protected abstract ClientHttpResponse executeInternal(HttpHeaders var1, byte[] var2) throws IOException;
}

