/*
 * Decompiled with CFR 0.152.
 */
package infra.http;

import infra.http.HttpOutputMessage;
import infra.util.StreamUtils;
import java.io.IOException;
import java.io.OutputStream;

public interface StreamingHttpOutputMessage
extends HttpOutputMessage {
    public void setBody(Body var1);

    public static void writeBody(HttpOutputMessage outputMessage, final byte[] body) throws IOException {
        if (outputMessage instanceof StreamingHttpOutputMessage) {
            StreamingHttpOutputMessage streaming = (StreamingHttpOutputMessage)outputMessage;
            streaming.setBody(new Body(){

                @Override
                public void writeTo(OutputStream outputStream) throws IOException {
                    StreamUtils.copy((byte[])body, (OutputStream)outputStream);
                }

                @Override
                public boolean repeatable() {
                    return true;
                }
            });
        } else {
            StreamUtils.copy((byte[])body, (OutputStream)outputMessage.getBody());
        }
    }

    @FunctionalInterface
    public static interface Body {
        public void writeTo(OutputStream var1) throws IOException;

        default public boolean repeatable() {
            return false;
        }
    }
}

