/*
 * Decompiled with CFR 0.152.
 */
package infra.http;

import infra.http.HttpStatusCode;
import java.io.Serializable;

final class SimpleHttpStatusCode
implements HttpStatusCode,
Comparable<HttpStatusCode>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int value;

    public SimpleHttpStatusCode(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public boolean is1xxInformational() {
        return this.hundreds() == 1;
    }

    @Override
    public boolean is2xxSuccessful() {
        return this.hundreds() == 2;
    }

    @Override
    public boolean is3xxRedirection() {
        return this.hundreds() == 3;
    }

    @Override
    public boolean is4xxClientError() {
        return this.hundreds() == 4;
    }

    @Override
    public boolean is5xxServerError() {
        return this.hundreds() == 5;
    }

    @Override
    public boolean isError() {
        int hundreds = this.hundreds();
        return hundreds == 4 || hundreds == 5;
    }

    private int hundreds() {
        return this.value / 100;
    }

    @Override
    public int compareTo(HttpStatusCode o) {
        return Integer.compare(this.value, o.value());
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HttpStatusCode) {
            HttpStatusCode other = (HttpStatusCode)obj;
            return this.value == other.value();
        }
        return false;
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

