/*
 * Decompiled with CFR 0.152.
 */
package infra.http;

import infra.http.CacheControl;
import infra.http.DefaultHttpHeaders;
import infra.http.HttpEntity;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.MediaType;
import infra.http.ProblemDetail;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class ResponseEntity<T>
extends HttpEntity<T> {
    private final Object status;

    public ResponseEntity(HttpStatusCode status) {
        this(null, null, status);
    }

    public ResponseEntity(@Nullable T body, HttpStatusCode status) {
        this(body, null, status);
    }

    public ResponseEntity(@Nullable MultiValueMap<String, String> headers, HttpStatusCode status) {
        this(null, headers, status);
    }

    public ResponseEntity(@Nullable T body, @Nullable MultiValueMap<String, String> headers, HttpStatusCode status) {
        super(body, headers);
        Assert.notNull((Object)status, (String)"HttpStatusCode is required");
        this.status = status;
    }

    public ResponseEntity(@Nullable T body, @Nullable MultiValueMap<String, String> headers, int rawStatus) {
        this(body, headers, (Object)rawStatus);
    }

    private ResponseEntity(@Nullable T body, @Nullable MultiValueMap<String, String> headers, Object status) {
        super(body, headers);
        Assert.notNull((Object)status, (String)"HttpStatusCode is required");
        this.status = status;
    }

    public HttpStatusCode getStatusCode() {
        if (this.status instanceof HttpStatusCode) {
            return (HttpStatusCode)this.status;
        }
        return HttpStatusCode.valueOf((Integer)this.status);
    }

    public int getStatusCodeValue() {
        if (this.status instanceof HttpStatusCode) {
            return ((HttpStatusCode)this.status).value();
        }
        return (Integer)this.status;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        ResponseEntity otherEntity = (ResponseEntity)other;
        return Objects.equals(this.status, otherEntity.status);
    }

    @Override
    public int hashCode() {
        return 29 * super.hashCode() + Objects.hashCode(this.status);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("<");
        builder.append(this.status);
        Object object = this.status;
        if (object instanceof HttpStatus) {
            HttpStatus s = (HttpStatus)object;
            builder.append(' ');
            builder.append(s.getReasonPhrase());
        }
        builder.append(',');
        Object body = this.getBody();
        HttpHeaders headers = this.getHeaders();
        if (body != null) {
            builder.append(body);
            builder.append(',');
        }
        builder.append(headers);
        builder.append('>');
        return builder.toString();
    }

    public static BodyBuilder status(HttpStatusCode status) {
        Assert.notNull((Object)status, (String)"HttpStatusCode is required");
        return new DefaultBuilder(status);
    }

    public static BodyBuilder status(int status) {
        return new DefaultBuilder(status);
    }

    public static BodyBuilder ok() {
        return ResponseEntity.status(HttpStatus.OK);
    }

    public static <T> ResponseEntity<T> ok(T body) {
        return ResponseEntity.ok().body(body);
    }

    public static <T> ResponseEntity<T> of(Optional<T> body) {
        Assert.notNull(body, (String)"Body is required");
        return body.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    public static HeadersBuilder<?> of(final ProblemDetail body) {
        return new DefaultBuilder(body.getStatus()){

            @Override
            public <T> ResponseEntity<T> build() {
                return this.body(body);
            }
        };
    }

    public static BodyBuilder created(URI location) {
        return (BodyBuilder)ResponseEntity.status(HttpStatus.CREATED).location(location);
    }

    public static BodyBuilder accepted() {
        return ResponseEntity.status(HttpStatus.ACCEPTED);
    }

    public static HeadersBuilder<?> noContent() {
        return ResponseEntity.status(HttpStatus.NO_CONTENT);
    }

    public static BodyBuilder badRequest() {
        return ResponseEntity.status(HttpStatus.BAD_REQUEST);
    }

    public static HeadersBuilder<?> notFound() {
        return ResponseEntity.status(HttpStatus.NOT_FOUND);
    }

    public static BodyBuilder unprocessableEntity() {
        return ResponseEntity.status(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    private static class DefaultBuilder
    implements BodyBuilder {
        private final Object statusCode;
        private final DefaultHttpHeaders headers = new DefaultHttpHeaders();

        public DefaultBuilder(Object statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public BodyBuilder header(String headerName, String ... headerValues) {
            this.headers.setOrRemove(headerName, headerValues);
            return this;
        }

        @Override
        public BodyBuilder headers(@Nullable HttpHeaders headers) {
            if (headers != null) {
                this.headers.addAll((Map)((Object)headers));
            }
            return this;
        }

        @Override
        public BodyBuilder headers(Consumer<HttpHeaders> headersConsumer) {
            headersConsumer.accept(this.headers);
            return this;
        }

        @Override
        public BodyBuilder allow(HttpMethod ... allowedMethods) {
            this.headers.setAllow(new LinkedHashSet<HttpMethod>(Arrays.asList(allowedMethods)));
            return this;
        }

        @Override
        public BodyBuilder contentLength(long contentLength) {
            this.headers.setContentLength(contentLength);
            return this;
        }

        @Override
        public BodyBuilder contentType(MediaType contentType) {
            this.headers.setContentType(contentType);
            return this;
        }

        @Override
        public BodyBuilder eTag(@Nullable String etag) {
            this.headers.setETag(etag);
            return this;
        }

        @Override
        public BodyBuilder lastModified(ZonedDateTime date) {
            this.headers.setLastModified(date);
            return this;
        }

        @Override
        public BodyBuilder lastModified(Instant date) {
            this.headers.setLastModified(date);
            return this;
        }

        @Override
        public BodyBuilder lastModified(long date) {
            this.headers.setLastModified(date);
            return this;
        }

        @Override
        public BodyBuilder location(URI location) {
            this.headers.setLocation(location);
            return this;
        }

        @Override
        public BodyBuilder cacheControl(CacheControl cacheControl) {
            this.headers.setCacheControl(cacheControl);
            return this;
        }

        @Override
        public BodyBuilder varyBy(String ... requestHeaders) {
            this.headers.setVary(Arrays.asList(requestHeaders));
            return this;
        }

        @Override
        public <T> ResponseEntity<T> build() {
            return this.body(null);
        }

        @Override
        public <T> ResponseEntity<T> body(@Nullable T body) {
            return new ResponseEntity<T>(body, (MultiValueMap<String, String>)this.headers, this.statusCode);
        }
    }

    public static interface BodyBuilder
    extends HeadersBuilder<BodyBuilder> {
        public BodyBuilder contentLength(long var1);

        public BodyBuilder contentType(MediaType var1);

        public <T> ResponseEntity<T> body(@Nullable T var1);
    }

    public static interface HeadersBuilder<B extends HeadersBuilder<B>> {
        public B header(String var1, String ... var2);

        public B headers(@Nullable HttpHeaders var1);

        public B headers(Consumer<HttpHeaders> var1);

        public B allow(HttpMethod ... var1);

        public B eTag(@Nullable String var1);

        public B lastModified(ZonedDateTime var1);

        public B lastModified(Instant var1);

        public B lastModified(long var1);

        public B location(URI var1);

        public B cacheControl(CacheControl var1);

        public B varyBy(String ... var1);

        public <T> ResponseEntity<T> build();
    }
}

