/*
 * Decompiled with CFR 0.152.
 */
package infra.http;

import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import java.time.Duration;

public final class ResponseCookie
extends HttpCookie {
    private final Duration maxAge;
    @Nullable
    private final String domain;
    @Nullable
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;
    private final boolean partitioned;
    @Nullable
    private final String sameSite;

    private ResponseCookie(String name, @Nullable String value, Duration maxAge, @Nullable String domain, @Nullable String path, boolean secure, boolean httpOnly, boolean partitioned, @Nullable String sameSite) {
        super(name, value);
        Assert.notNull((Object)maxAge, (String)"Max age is required");
        this.maxAge = maxAge;
        this.domain = domain;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.partitioned = partitioned;
        this.sameSite = sameSite;
        Rfc6265Utils.validateCookieName(name);
        Rfc6265Utils.validateCookieValue(value);
        Rfc6265Utils.validateDomain(domain);
        Rfc6265Utils.validatePath(path);
    }

    public Duration getMaxAge() {
        return this.maxAge;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean isPartitioned() {
        return this.partitioned;
    }

    @Nullable
    public String getSameSite() {
        return this.sameSite;
    }

    public ResponseCookieBuilder mutate() {
        return new DefaultResponseCookieBuilder(this.getName(), this.getValue(), false).maxAge(this.maxAge).domain(this.domain).path(this.path).secure(this.secure).httpOnly(this.httpOnly).partitioned(this.partitioned).sameSite(this.sameSite);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof ResponseCookie)) return false;
        ResponseCookie that = (ResponseCookie)other;
        if (!this.getName().equalsIgnoreCase(that.getName())) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.path, (Object)that.getPath())) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.domain, (Object)that.getDomain())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.domain);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.path);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append('=').append(this.getValue());
        if (StringUtils.hasText((String)this.getPath())) {
            sb.append("; Path=").append(this.getPath());
        }
        if (StringUtils.hasText((String)this.domain)) {
            sb.append("; Domain=").append(this.domain);
        }
        if (!this.maxAge.isNegative()) {
            sb.append("; Max-Age=").append(this.maxAge.getSeconds());
            sb.append("; Expires=");
            long millis = this.maxAge.getSeconds() > 0L ? System.currentTimeMillis() + this.maxAge.toMillis() : 0L;
            sb.append(HttpHeaders.formatDate(millis));
        }
        if (this.secure) {
            sb.append("; Secure");
        }
        if (this.httpOnly) {
            sb.append("; HttpOnly");
        }
        if (this.partitioned) {
            sb.append("; Partitioned");
        }
        if (StringUtils.hasText((String)this.sameSite)) {
            sb.append("; SameSite=").append(this.sameSite);
        }
        return sb.toString();
    }

    public static ResponseCookieBuilder from(String name) {
        return new DefaultResponseCookieBuilder(name, null, false);
    }

    public static ResponseCookieBuilder from(String name, String value) {
        return new DefaultResponseCookieBuilder(name, value, false);
    }

    public static ResponseCookieBuilder fromClientResponse(String name, String value) {
        return new DefaultResponseCookieBuilder(name, value, true);
    }

    private static class Rfc6265Utils {
        private static final String SEPARATOR_CHARS = new String(new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '=', '{', '}', ' '});
        private static final String DOMAIN_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.-";

        private Rfc6265Utils() {
        }

        public static void validateCookieName(String name) {
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c <= '\u001f' || c == '\u007f') {
                    throw new IllegalArgumentException(name + ": RFC2616 token cannot have control chars");
                }
                if (SEPARATOR_CHARS.indexOf(c) >= 0) {
                    throw new IllegalArgumentException(name + ": RFC2616 token cannot have separator chars such as '" + c + "'");
                }
                if (c < '\u0080') continue;
                throw new IllegalArgumentException(name + ": RFC2616 token can only have US-ASCII: 0x" + Integer.toHexString(c));
            }
        }

        public static void validateCookieValue(@Nullable String value) {
            if (value == null) {
                return;
            }
            int start = 0;
            int end = value.length();
            if (end > 1 && value.charAt(0) == '\"' && value.charAt(end - 1) == '\"') {
                start = 1;
                --end;
            }
            for (int i = start; i < end; ++i) {
                char c = value.charAt(i);
                if (c < '!' || c == '\"' || c == ',' || c == ';' || c == '\\' || c == '\u007f') {
                    throw new IllegalArgumentException("RFC2616 cookie value cannot have '" + c + "'");
                }
                if (c < '\u0080') continue;
                throw new IllegalArgumentException("RFC2616 cookie value can only have US-ASCII chars: 0x" + Integer.toHexString(c));
            }
        }

        public static void validateDomain(@Nullable String domain) {
            if (StringUtils.isEmpty((CharSequence)domain)) {
                return;
            }
            char char1 = domain.charAt(0);
            int length = domain.length();
            char charN = domain.charAt(length - 1);
            if (char1 == '-' || charN == '.' || charN == '-') {
                throw new IllegalArgumentException("Invalid first/last char in cookie domain: " + domain);
            }
            int c = -1;
            for (int i = 0; i < length; ++i) {
                int p = c;
                c = domain.charAt(i);
                if (DOMAIN_CHARS.indexOf(c) != -1 && (p != 46 || c != 46 && c != 45) && (p != 45 || c != 46)) continue;
                throw new IllegalArgumentException(domain + ": invalid cookie domain char '" + c + "'");
            }
        }

        public static void validatePath(@Nullable String path) {
            if (path == null) {
                return;
            }
            for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (c >= ' ' && c <= '~' && c != ';') continue;
                throw new IllegalArgumentException("%s: Invalid cookie path char '%s'".formatted(path, Character.valueOf(c)));
            }
        }
    }

    private static class DefaultResponseCookieBuilder
    implements ResponseCookieBuilder {
        private final String name;
        @Nullable
        private String value;
        private final boolean lenient;
        private Duration maxAge = Duration.ofSeconds(-1L);
        @Nullable
        private String domain;
        @Nullable
        private String path;
        private boolean secure;
        private boolean httpOnly;
        private boolean partitioned;
        @Nullable
        private String sameSite;

        public DefaultResponseCookieBuilder(String name, @Nullable String value, boolean lenient) {
            this.name = name;
            this.value = value;
            this.lenient = lenient;
        }

        @Override
        public ResponseCookieBuilder value(@Nullable String value) {
            this.value = value;
            return this;
        }

        @Override
        public ResponseCookieBuilder maxAge(Duration maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        @Override
        public ResponseCookieBuilder maxAge(long maxAgeSeconds) {
            this.maxAge = maxAgeSeconds >= 0L ? Duration.ofSeconds(maxAgeSeconds) : Duration.ofSeconds(-1L);
            return this;
        }

        @Override
        public ResponseCookieBuilder domain(@Nullable String domain) {
            this.domain = this.initDomain(domain);
            return this;
        }

        @Nullable
        private String initDomain(@Nullable String domain) {
            String str;
            if (this.lenient && StringUtils.isNotEmpty((CharSequence)domain) && (str = domain.trim()).startsWith("\"") && str.endsWith("\"") && str.substring(1, str.length() - 1).trim().isEmpty()) {
                return null;
            }
            return domain;
        }

        @Override
        public ResponseCookieBuilder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        @Override
        public ResponseCookieBuilder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        @Override
        public ResponseCookieBuilder httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        @Override
        public ResponseCookieBuilder partitioned(boolean partitioned) {
            this.partitioned = partitioned;
            return this;
        }

        @Override
        public ResponseCookieBuilder sameSite(@Nullable String sameSite) {
            this.sameSite = sameSite;
            return this;
        }

        @Override
        public ResponseCookie build() {
            return new ResponseCookie(this.name, this.value, this.maxAge, this.domain, this.path, this.secure, this.httpOnly, this.partitioned, this.sameSite);
        }
    }

    public static interface ResponseCookieBuilder {
        public ResponseCookieBuilder value(@Nullable String var1);

        public ResponseCookieBuilder maxAge(Duration var1);

        public ResponseCookieBuilder maxAge(long var1);

        public ResponseCookieBuilder path(@Nullable String var1);

        public ResponseCookieBuilder domain(@Nullable String var1);

        public ResponseCookieBuilder secure(boolean var1);

        public ResponseCookieBuilder httpOnly(boolean var1);

        public ResponseCookieBuilder partitioned(boolean var1);

        public ResponseCookieBuilder sameSite(@Nullable String var1);

        public ResponseCookie build();
    }
}

