/*
 * Decompiled with CFR 0.152.
 */
package infra.http;

import infra.http.DefaultHttpHeaders;
import infra.http.HttpHeaders;
import infra.http.MediaType;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

class ReadOnlyHttpHeaders
extends DefaultHttpHeaders {
    private static final long serialVersionUID = 1L;
    public static final ReadOnlyHttpHeaders EMPTY = new ReadOnlyHttpHeaders((MultiValueMap<String, String>)MultiValueMap.EMPTY);
    @Nullable
    private MediaType cachedContentType;
    @Nullable
    private List<MediaType> cachedAccept;

    ReadOnlyHttpHeaders(MultiValueMap<String, String> headers) {
        super(headers);
    }

    @Override
    public MediaType getContentType() {
        MediaType contentType;
        if (this.cachedContentType != null) {
            return this.cachedContentType;
        }
        this.cachedContentType = contentType = super.getContentType();
        return contentType;
    }

    @Override
    public List<MediaType> getAccept() {
        if (this.cachedAccept != null) {
            return this.cachedAccept;
        }
        List<MediaType> accept = super.getAccept();
        this.cachedAccept = accept;
        return accept;
    }

    @Override
    public void clearContentHeaders() {
    }

    @Override
    public List<String> get(Object name) {
        List values = (List)this.headers.get(name);
        return values != null ? Collections.unmodifiableList(values) : null;
    }

    @Override
    public void add(String name, @Nullable String value) {
        throw new UnsupportedOperationException();
    }

    public void addAll(String key, @Nullable Collection<? extends String> values) {
        throw new UnsupportedOperationException();
    }

    public void addAll(String key, @Nullable Enumeration<? extends String> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> setOrRemove(String name, @Nullable String value) {
        throw new UnsupportedOperationException();
    }

    public void setAll(@Nullable Map<String, List<String>> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> put(String key, List<String> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> remove(Object name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpHeaders asWritable() {
        return new DefaultHttpHeaders((MultiValueMap<String, String>)this.headers);
    }

    @Override
    public HttpHeaders asReadOnly() {
        return this;
    }
}

