/*
 * Decompiled with CFR 0.152.
 */
package infra.http;

import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.lang.Assert;
import infra.lang.Nullable;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ProblemDetail {
    private static final URI BLANK_TYPE = URI.create("about:blank");
    private URI type = BLANK_TYPE;
    @Nullable
    private String title;
    private int status;
    @Nullable
    private String detail;
    @Nullable
    private URI instance;
    @Nullable
    private Map<String, Object> properties;

    protected ProblemDetail() {
    }

    protected ProblemDetail(int rawStatusCode) {
        this.status = rawStatusCode;
    }

    protected ProblemDetail(ProblemDetail other) {
        this.type = other.type;
        this.title = other.title;
        this.status = other.status;
        this.detail = other.detail;
        this.instance = other.instance;
        this.properties = other.properties != null ? new LinkedHashMap<String, Object>(other.properties) : null;
    }

    public ProblemDetail withType(URI type) {
        this.setType(type);
        return this;
    }

    public ProblemDetail withTitle(@Nullable String title) {
        this.setTitle(title);
        return this;
    }

    public ProblemDetail withStatus(HttpStatusCode status) {
        Assert.notNull((Object)status, (String)"HttpStatusCode is required");
        this.setStatus(status.value());
        return this;
    }

    public ProblemDetail withRawStatusCode(int status) {
        this.setStatus(status);
        return this;
    }

    public ProblemDetail withDetail(@Nullable String detail) {
        this.setDetail(detail);
        return this;
    }

    public ProblemDetail withInstance(@Nullable URI instance) {
        this.setInstance(instance);
        return this;
    }

    public void setType(URI type) {
        Assert.notNull((Object)type, (String)"'type' is required");
        this.type = type;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(HttpStatus httpStatus) {
        this.status = httpStatus.value();
    }

    public void setDetail(@Nullable String detail) {
        this.detail = detail;
    }

    public void setInstance(@Nullable URI instance) {
        this.instance = instance;
    }

    public void setProperty(String name, @Nullable Object value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    public void setProperties(@Nullable Map<String, Object> properties) {
        this.properties = properties;
    }

    public URI getType() {
        return this.type;
    }

    @Nullable
    public String getTitle() {
        HttpStatus httpStatus;
        if (this.title == null && (httpStatus = HttpStatus.resolve(this.status)) != null) {
            return httpStatus.getReasonPhrase();
        }
        return this.title;
    }

    public int getStatus() {
        return this.status;
    }

    @Nullable
    public String getDetail() {
        return this.detail;
    }

    @Nullable
    public URI getInstance() {
        return this.instance;
    }

    @Nullable
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ProblemDetail) {
            ProblemDetail otherDetail = (ProblemDetail)other;
            return this.status == otherDetail.status && Objects.equals(this.type, otherDetail.type) && Objects.equals(this.getTitle(), otherDetail.getTitle()) && Objects.equals(this.detail, otherDetail.detail) && Objects.equals(this.instance, otherDetail.instance) && Objects.equals(this.properties, otherDetail.properties);
        }
        return false;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + Objects.hashCode(this.getTitle());
        result = 31 * result + this.status;
        result = 31 * result + Objects.hashCode(this.detail);
        result = 31 * result + Objects.hashCode(this.instance);
        result = 31 * result + Objects.hashCode(this.properties);
        return result;
    }

    public String toString() {
        return "%s[%s]".formatted(this.getClass().getSimpleName(), this.initToStringContent());
    }

    protected String initToStringContent() {
        return "type='%s', title='%s', status=%d, detail='%s', instance='%s', properties='%s'".formatted(this.getType(), this.getTitle(), this.getStatus(), this.getDetail(), this.getInstance(), this.getProperties());
    }

    public static ProblemDetail forStatus(HttpStatusCode status) {
        Assert.notNull((Object)status, (String)"HttpStatusCode is required");
        return ProblemDetail.forRawStatusCode(status.value());
    }

    public static ProblemDetail forRawStatusCode(int status) {
        return new ProblemDetail(status);
    }

    public static ProblemDetail forStatusAndDetail(HttpStatusCode status, String detail) {
        return ProblemDetail.forStatus(status).withDetail(detail);
    }
}

