/*
 * Decompiled with CFR 0.152.
 */
package infra.http;

import infra.core.io.Resource;
import infra.http.InvalidMediaTypeException;
import infra.http.MediaTypeFactory;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.InvalidMimeTypeException;
import infra.util.MimeType;
import infra.util.MimeTypeUtils;
import infra.util.StringUtils;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MediaType
extends MimeType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final MediaType ALL = new MediaType("*", "*");
    public static final MediaType APPLICATION_ATOM_XML = new MediaType("application", "atom+xml");
    public static final String APPLICATION_ATOM_XML_VALUE = "application/atom+xml";
    public static final MediaType APPLICATION_CBOR = new MediaType("application", "cbor");
    public static final String APPLICATION_CBOR_VALUE = "application/cbor";
    public static final MediaType APPLICATION_FORM_URLENCODED = new MediaType("application", "x-www-form-urlencoded");
    public static final String APPLICATION_FORM_URLENCODED_VALUE = "application/x-www-form-urlencoded";
    public static final MediaType APPLICATION_JSON = new MediaType("application", "json");
    public static final MediaType APPLICATION_YAML = new MediaType("application", "yaml");
    public static final MediaType APPLICATION_OCTET_STREAM = new MediaType("application", "octet-stream");
    public static final MediaType APPLICATION_PDF = new MediaType("application", "pdf");
    public static final MediaType APPLICATION_PROBLEM_JSON = new MediaType("application", "problem+json");
    public static final String APPLICATION_PROBLEM_JSON_VALUE = "application/problem+json";
    public static final MediaType APPLICATION_PROBLEM_XML = new MediaType("application", "problem+xml");
    public static final String APPLICATION_PROBLEM_XML_VALUE = "application/problem+xml";
    public static final MediaType APPLICATION_RSS_XML = new MediaType("application", "rss+xml");
    public static final String APPLICATION_RSS_XML_VALUE = "application/rss+xml";
    public static final MediaType APPLICATION_NDJSON = new MediaType("application", "x-ndjson");
    public static final String APPLICATION_NDJSON_VALUE = "application/x-ndjson";
    public static final MediaType APPLICATION_STREAM_JSON = new MediaType("application", "stream+json");
    public static final String APPLICATION_STREAM_JSON_VALUE = "application/stream+json";
    public static final MediaType APPLICATION_XHTML_XML = new MediaType("application", "xhtml+xml");
    public static final String APPLICATION_XHTML_XML_VALUE = "application/xhtml+xml";
    public static final MediaType APPLICATION_XML = new MediaType("application", "xml");
    public static final MediaType IMAGE_GIF = new MediaType("image", "gif");
    public static final MediaType IMAGE_JPEG = new MediaType("image", "jpeg");
    public static final MediaType IMAGE_PNG = new MediaType("image", "png");
    public static final MediaType MULTIPART_FORM_DATA = new MediaType("multipart", "form-data");
    public static final String MULTIPART_FORM_DATA_VALUE = "multipart/form-data";
    public static final MediaType MULTIPART_MIXED = new MediaType("multipart", "mixed");
    public static final String MULTIPART_MIXED_VALUE = "multipart/mixed";
    public static final MediaType MULTIPART_RELATED = new MediaType("multipart", "related");
    public static final String MULTIPART_RELATED_VALUE = "multipart/related";
    public static final MediaType TEXT_EVENT_STREAM = new MediaType("text", "event-stream");
    public static final String TEXT_EVENT_STREAM_VALUE = "text/event-stream";
    public static final MediaType TEXT_HTML = new MediaType("text", "html");
    public static final MediaType TEXT_MARKDOWN = new MediaType("text", "markdown");
    public static final String TEXT_MARKDOWN_VALUE = "text/markdown";
    public static final MediaType TEXT_PLAIN = new MediaType("text", "plain");
    public static final MediaType TEXT_XML = new MediaType("text", "xml");
    public static final MediaType APPLICATION_PROTOBUF = new MediaType("application", "x-protobuf");
    public static final String APPLICATION_PROTOBUF_VALUE = "application/x-protobuf";
    private static final String PARAM_QUALITY_FACTOR = "q";
    public static final Comparator<MediaType> QUALITY_VALUE_COMPARATOR = (mediaType1, mediaType2) -> {
        double quality1 = mediaType1.getQualityValue();
        double quality2 = mediaType2.getQualityValue();
        int qualityComparison = Double.compare(quality2, quality1);
        if (qualityComparison != 0) {
            return qualityComparison;
        }
        if (mediaType1.isWildcardType() && !mediaType2.isWildcardType()) {
            return 1;
        }
        if (mediaType2.isWildcardType() && !mediaType1.isWildcardType()) {
            return -1;
        }
        if (!mediaType1.getType().equals(mediaType2.getType())) {
            return 0;
        }
        if (mediaType1.isWildcardSubtype() && !mediaType2.isWildcardSubtype()) {
            return 1;
        }
        if (mediaType2.isWildcardSubtype() && !mediaType1.isWildcardSubtype()) {
            return -1;
        }
        if (!mediaType1.getSubtype().equals(mediaType2.getSubtype())) {
            return 0;
        }
        int paramsSize1 = mediaType1.getParameters().size();
        int paramsSize2 = mediaType2.getParameters().size();
        return Integer.compare(paramsSize2, paramsSize1);
    };
    public static final Comparator<MediaType> SPECIFICITY_COMPARATOR = new MimeType.SpecificityComparator<MediaType>(){

        protected int compareParameters(MediaType mediaType1, MediaType mediaType2) {
            double quality1 = mediaType1.getQualityValue();
            double quality2 = mediaType2.getQualityValue();
            int qualityComparison = Double.compare(quality2, quality1);
            if (qualityComparison != 0) {
                return qualityComparison;
            }
            return super.compareParameters((MimeType)mediaType1, (MimeType)mediaType2);
        }
    };

    public MediaType(String type) {
        super(type);
    }

    public MediaType(String type, String subtype) {
        super(type, subtype);
    }

    public MediaType(String type, String subtype, Charset charset) {
        super(type, subtype, charset);
    }

    public MediaType(String type, String subtype, double qualityValue) {
        this(type, subtype, Map.of(PARAM_QUALITY_FACTOR, Double.toString(qualityValue)));
    }

    public MediaType(MediaType other, Charset charset) {
        super((MimeType)other, charset);
    }

    public MediaType(MediaType other, @Nullable Map<String, String> parameters) {
        super(other.getType(), other.getSubtype(), parameters);
    }

    public MediaType(String type, String subtype, @Nullable Map<String, String> parameters) {
        super(type, subtype, parameters);
    }

    private MediaType(MimeType mimeType) {
        super(mimeType);
        for (Map.Entry entry : this.getParameters().entrySet()) {
            this.checkParameters((String)entry.getKey(), (String)entry.getValue());
        }
    }

    protected void checkParameters(String attribute, String value) {
        double d;
        super.checkParameters(attribute, value);
        if (!(!PARAM_QUALITY_FACTOR.equals(attribute) || (d = Double.parseDouble(value = this.unquote(value))) >= 0.0 && d <= 1.0)) {
            throw new IllegalArgumentException("Invalid quality value \"" + value + "\": should be between 0.0 and 1.0");
        }
    }

    public double getQualityValue() {
        String qualityFactor = this.getParameter(PARAM_QUALITY_FACTOR);
        return qualityFactor != null ? Double.parseDouble(this.unquote(qualityFactor)) : 1.0;
    }

    public boolean includes(MediaType other) {
        return super.includes((MimeType)other);
    }

    public boolean isCompatibleWith(@Nullable MediaType other) {
        return super.isCompatibleWith((MimeType)other);
    }

    public MediaType copyQualityValue(MediaType mediaType) {
        if (!mediaType.getParameters().containsKey(PARAM_QUALITY_FACTOR)) {
            return this;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(this.getParameters());
        params.put(PARAM_QUALITY_FACTOR, (String)mediaType.getParameters().get(PARAM_QUALITY_FACTOR));
        return new MediaType(this, params);
    }

    public MediaType removeQualityValue() {
        if (!this.getParameters().containsKey(PARAM_QUALITY_FACTOR)) {
            return this;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(this.getParameters());
        params.remove(PARAM_QUALITY_FACTOR);
        return new MediaType(this, params);
    }

    public MediaType withCharset(Charset charset) {
        return new MediaType(this, charset);
    }

    public static MediaType valueOf(String value) {
        return MediaType.parseMediaType(value);
    }

    public static MediaType parseMediaType(String mediaType) {
        try {
            MimeType type = MimeTypeUtils.parseMimeType((String)mediaType);
            try {
                return new MediaType(type);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidMediaTypeException(mediaType, ex.getMessage());
            }
        }
        catch (InvalidMimeTypeException ex) {
            throw new InvalidMediaTypeException(ex);
        }
    }

    public static List<MediaType> parseMediaTypes(String mediaTypes) {
        if (StringUtils.isEmpty((CharSequence)mediaTypes)) {
            return Collections.emptyList();
        }
        List tokenizedTypes = MimeTypeUtils.tokenize((String)mediaTypes);
        ArrayList<MediaType> result = new ArrayList<MediaType>(tokenizedTypes.size());
        for (String type : tokenizedTypes) {
            if (!StringUtils.hasText((String)type)) continue;
            result.add(MediaType.parseMediaType(type));
        }
        return result;
    }

    public static List<MediaType> parseMediaTypes(@Nullable List<String> mediaTypes) {
        if (CollectionUtils.isEmpty(mediaTypes)) {
            return Collections.emptyList();
        }
        if (mediaTypes.size() == 1) {
            return MediaType.parseMediaTypes(mediaTypes.get(0));
        }
        ArrayList<MediaType> result = new ArrayList<MediaType>(8);
        for (String mediaType : mediaTypes) {
            result.addAll(MediaType.parseMediaTypes(mediaType));
        }
        return result;
    }

    public static List<MediaType> asMediaTypes(List<MimeType> mimeTypes) {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(mimeTypes.size());
        for (MimeType mimeType : mimeTypes) {
            mediaTypes.add(MediaType.asMediaType(mimeType));
        }
        return mediaTypes;
    }

    public static MediaType asMediaType(MimeType mimeType) {
        return mimeType instanceof MediaType ? (MediaType)mimeType : new MediaType(mimeType);
    }

    public static String toString(Collection<MediaType> mediaTypes) {
        return MimeTypeUtils.toString(mediaTypes);
    }

    public boolean isMoreSpecific(MimeType other) {
        Assert.notNull((Object)other, (String)"Other is required");
        if (other instanceof MediaType) {
            double quality2;
            MediaType otherMediaType = (MediaType)other;
            double quality1 = this.getQualityValue();
            if (quality1 > (quality2 = otherMediaType.getQualityValue())) {
                return true;
            }
            if (quality1 < quality2) {
                return false;
            }
        }
        return super.isMoreSpecific(other);
    }

    public boolean isLessSpecific(MimeType other) {
        Assert.notNull((Object)other, (String)"Other is required");
        return other.isMoreSpecific((MimeType)this);
    }

    public static void sortBySpecificity(List<MediaType> mediaTypes) {
        Assert.notNull(mediaTypes, (String)"'mediaTypes' is required");
        if (mediaTypes.size() > 1) {
            mediaTypes.sort(SPECIFICITY_COMPARATOR);
        }
    }

    public static void sortByQualityValue(List<MediaType> mediaTypes) {
        Assert.notNull(mediaTypes, (String)"'mediaTypes' is required");
        if (mediaTypes.size() > 1) {
            mediaTypes.sort(QUALITY_VALUE_COMPARATOR);
        }
    }

    public static void sortBySpecificityAndQuality(List<MediaType> mediaTypes) {
        Assert.notNull(mediaTypes, (String)"'mediaTypes' is required");
        if (mediaTypes.size() > 1) {
            mediaTypes.sort(SPECIFICITY_COMPARATOR.thenComparing(QUALITY_VALUE_COMPARATOR));
        }
    }

    @Nullable
    public static MediaType fromResource(@Nullable Resource resource) {
        return resource == null ? null : MediaType.fromFileName(resource.getName());
    }

    @Nullable
    public static MediaType fromFileName(@Nullable String filename) {
        Optional<MediaType> mediaType = MediaTypeFactory.getMediaType(filename);
        return mediaType.orElse(null);
    }
}

