/*
 * Decompiled with CFR 0.152.
 */
package infra.http;

import infra.http.HttpStatus;
import infra.http.SimpleHttpStatusCode;
import java.io.Serializable;

public interface HttpStatusCode
extends Serializable {
    public int value();

    public boolean is1xxInformational();

    public boolean is2xxSuccessful();

    public boolean is3xxRedirection();

    public boolean is4xxClientError();

    public boolean is5xxServerError();

    public boolean isError();

    default public boolean isSameCodeAs(HttpStatusCode other) {
        return this.value() == other.value();
    }

    public static HttpStatusCode valueOf(int code) {
        if (code < 100 || code > 999) {
            throw new IllegalArgumentException("Code '%d' should be a three-digit positive integer".formatted(code));
        }
        HttpStatus status = HttpStatus.resolve(code);
        if (status == null) {
            return new SimpleHttpStatusCode(code);
        }
        return status;
    }
}

