/*
 * Decompiled with CFR 0.152.
 */
package infra.http;

import infra.http.HttpMessage;
import infra.http.MediaType;
import infra.lang.Nullable;
import infra.util.ExceptionUtils;
import infra.util.StreamUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public interface HttpOutputMessage
extends HttpMessage {
    public OutputStream getBody() throws IOException;

    default public void setContentType(@Nullable MediaType mediaType) {
        this.getHeaders().setContentType(mediaType);
    }

    default public boolean supportsZeroCopy() {
        return false;
    }

    default public void sendFile(File file) {
        this.sendFile(file, 0L, file.length());
    }

    default public void sendFile(File file, long position, long count) {
        this.sendFile(file.toPath(), position, count);
    }

    default public void sendFile(Path file, long position, long count) {
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            StreamUtils.copyRange((InputStream)inputStream, (OutputStream)this.getBody(), (long)position, (long)count);
        }
        catch (IOException e) {
            throw ExceptionUtils.sneakyThrow((Throwable)e);
        }
    }
}

