/*
 * Decompiled with CFR 0.152.
 */
package infra.http;

import infra.lang.Nullable;
import java.util.Map;

public enum HttpMethod {
    GET,
    POST,
    PUT,
    DELETE,
    PATCH,
    TRACE,
    HEAD,
    OPTIONS,
    CONNECT;

    private static final Map<String, HttpMethod> mappings;

    public boolean matches(String method) {
        return this.name().equals(method);
    }

    @Nullable
    public static HttpMethod resolve(@Nullable String method) {
        return method != null ? mappings.get(method) : null;
    }

    static {
        mappings = Map.of(GET.name(), GET, POST.name(), POST, PUT.name(), PUT, DELETE.name(), DELETE, PATCH.name(), PATCH, TRACE.name(), TRACE, HEAD.name(), HEAD, OPTIONS.name(), OPTIONS, CONNECT.name(), CONNECT);
    }
}

