/*
 * Decompiled with CFR 0.152.
 */
package infra.http;

import infra.http.CacheControl;
import infra.http.ContentDisposition;
import infra.http.DefaultHttpHeaders;
import infra.http.ETag;
import infra.http.HttpMethod;
import infra.http.HttpRange;
import infra.http.InvalidMediaTypeException;
import infra.http.MediaType;
import infra.http.ReadOnlyHttpHeaders;
import infra.lang.Assert;
import infra.lang.Modifiable;
import infra.lang.Nullable;
import infra.lang.Unmodifiable;
import infra.util.CollectionUtils;
import infra.util.MultiValueMap;
import infra.util.StringUtils;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public abstract class HttpHeaders
implements MultiValueMap<String, String>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String ACCEPT_PATCH = "Accept-Patch";
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String AGE = "Age";
    public static final String ALLOW = "Allow";
    public static final String AUTHORIZATION = "Authorization";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONNECTION = "Connection";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_LOCATION = "Content-Location";
    public static final String CONTENT_RANGE = "Content-Range";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String COOKIE = "Cookie";
    public static final String DATE = "Date";
    public static final String ETAG = "ETag";
    public static final String EXPECT = "Expect";
    public static final String EXPIRES = "Expires";
    public static final String FROM = "From";
    public static final String HOST = "Host";
    public static final String IF_MATCH = "If-Match";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String IF_RANGE = "If-Range";
    public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String LINK = "Link";
    public static final String LOCATION = "Location";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String ORIGIN = "Origin";
    public static final String PRAGMA = "Pragma";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String RANGE = "Range";
    public static final String REFERER = "Referer";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String SERVER = "Server";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String SET_COOKIE2 = "Set-Cookie2";
    public static final String TE = "TE";
    public static final String TRAILER = "Trailer";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String UPGRADE = "Upgrade";
    public static final String USER_AGENT = "User-Agent";
    public static final String VARY = "Vary";
    public static final String VIA = "Via";
    public static final String WARNING = "Warning";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String X_REQUESTED_WITH = "X-Requested-With";
    public static final String SEC_WEBSOCKET_ORIGIN = "Sec-WebSocket-Origin";
    public static final String SEC_WEBSOCKET_ACCEPT = "Sec-WebSocket-Accept";
    public static final String SEC_WEBSOCKET_VERSION = "Sec-WebSocket-Version";
    public static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    public static final String SEC_WEBSOCKET_EXTENSIONS = "Sec-WebSocket-Extensions";
    public static final String SEC_WEBSOCKET_LOCATION = "Sec-WebSocket-Location";
    public static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    public static final String WEBSOCKET_LOCATION = "WebSocket-Location";
    public static final String WEBSOCKET_PROTOCOL = "WebSocket-Protocol";
    public static final String SEC_WEBSOCKET_KEY1 = "Sec-WebSocket-Key1";
    public static final String SEC_WEBSOCKET_KEY2 = "Sec-WebSocket-Key2";
    public static final String NONE = "none";
    public static final String GZIP = "gzip";
    public static final String BYTES = "bytes";
    public static final String CLOSE = "close";
    public static final String PUBLIC = "public";
    public static final String BASE64 = "base64";
    public static final String BINARY = "binary";
    public static final String CHUNKED = "chunked";
    public static final String CHARSET = "charset";
    public static final String MAX_AGE = "max-age";
    public static final String DEFLATE = "deflate";
    public static final String PRIVATE = "private";
    public static final String BOUNDARY = "boundary";
    public static final String IDENTITY = "identity";
    public static final String NO_CACHE = "no-cache";
    public static final String NO_STORE = "no-store";
    public static final String S_MAXAGE = "s-maxage";
    public static final String TRAILERS = "trailers";
    public static final String COMPRESS = "compress";
    public static final String MAX_STALE = "max-stale";
    public static final String MIN_FRESH = "min-fresh";
    public static final String WEBSOCKET = "WebSocket";
    public static final String KEEP_ALIVE = "keep-alive";
    public static final String GZIP_DEFLATE = "gzip,deflate";
    public static final String CONTINUE = "100-continue";
    public static final String NO_TRANSFORM = "no-transform";
    public static final String ONLY_IF_CACHED = "only-if-cached";
    public static final String XML_HTTP_REQUEST = "XMLHttpRequest";
    public static final String MUST_REVALIDATE = "must-revalidate";
    public static final String PROXY_REVALIDATE = "proxy-revalidate";
    public static final String QUOTED_PRINTABLE = "quoted-printable";
    public static final String INLINE_FILE_NAME = "inline;filename=\"";
    public static final String ATTACHMENT_FILE_NAME = "attachment;filename=\"";
    public static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.ROOT);
    public static final ZoneId GMT = ZoneId.of("GMT");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).withZone(GMT);
    public static final DateTimeFormatter[] DATE_PARSERS = new DateTimeFormatter[]{DateTimeFormatter.RFC_1123_DATE_TIME, DateTimeFormatter.ofPattern("EEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy", Locale.US).withZone(GMT)};

    public List<String> getOrEmpty(String headerName) {
        List<String> values = this.get(headerName);
        return values != null ? values : Collections.emptyList();
    }

    public void setAccept(Collection<MediaType> acceptableMediaTypes) {
        this.setOrRemove(ACCEPT, MediaType.toString(acceptableMediaTypes));
    }

    public List<MediaType> getAccept() {
        return MediaType.parseMediaTypes((List<String>)this.get(ACCEPT));
    }

    public void setAcceptLanguage(Collection<Locale.LanguageRange> languages) {
        Assert.notNull(languages, (String)"LanguageRange List is required");
        List values = languages.stream().map(range -> {
            if (range.getWeight() == 1.0) {
                return range.getRange();
            }
            DecimalFormat decimal = new DecimalFormat("0.0", DECIMAL_FORMAT_SYMBOLS);
            return range.getRange() + ";q=" + decimal.format(range.getWeight());
        }).collect(Collectors.toList());
        this.setOrRemove(ACCEPT_LANGUAGE, this.toCommaDelimitedString(values));
    }

    public List<Locale.LanguageRange> getAcceptLanguage() {
        String value = this.getFirst(ACCEPT_LANGUAGE);
        if (StringUtils.hasText((String)value)) {
            try {
                return Locale.LanguageRange.parse(value);
            }
            catch (IllegalArgumentException ignored) {
                Object[] tokens = StringUtils.tokenizeToStringArray((String)value, (String)",");
                for (int i = 0; i < tokens.length; ++i) {
                    tokens[i] = StringUtils.trimTrailingCharacter((String)tokens[i], (char)';');
                }
                value = StringUtils.arrayToCommaDelimitedString((Object[])tokens);
                return Locale.LanguageRange.parse(value);
            }
        }
        return Collections.emptyList();
    }

    public void setAcceptLanguageAsLocales(Collection<Locale> locales) {
        this.setAcceptLanguage(locales.stream().map(locale -> new Locale.LanguageRange(locale.toLanguageTag())).collect(Collectors.toList()));
    }

    public List<Locale> getAcceptLanguageAsLocales() {
        List<Locale.LanguageRange> ranges = this.getAcceptLanguage();
        if (ranges.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Locale> locales = new ArrayList<Locale>(ranges.size());
        for (Locale.LanguageRange range : ranges) {
            if (range.getRange().startsWith("*")) continue;
            locales.add(Locale.forLanguageTag(range.getRange()));
        }
        return locales;
    }

    public void setAcceptPatch(Collection<MediaType> mediaTypes) {
        this.setOrRemove(ACCEPT_PATCH, MediaType.toString(mediaTypes));
    }

    public List<MediaType> getAcceptPatch() {
        return MediaType.parseMediaTypes((List<String>)this.get(ACCEPT_PATCH));
    }

    public void setAccessControlAllowCredentials(boolean allowCredentials) {
        this.setOrRemove(ACCESS_CONTROL_ALLOW_CREDENTIALS, Boolean.toString(allowCredentials));
    }

    public boolean getAccessControlAllowCredentials() {
        return Boolean.parseBoolean(this.getFirst(ACCESS_CONTROL_ALLOW_CREDENTIALS));
    }

    public void setAccessControlAllowHeaders(Collection<String> allowedHeaders) {
        this.setOrRemove(ACCESS_CONTROL_ALLOW_HEADERS, this.toCommaDelimitedString(allowedHeaders));
    }

    public List<String> getAccessControlAllowHeaders() {
        return this.getValuesAsList(ACCESS_CONTROL_ALLOW_HEADERS);
    }

    public void setAccessControlAllowMethods(Collection<?> allowedMethods) {
        this.setOrRemove(ACCESS_CONTROL_ALLOW_METHODS, this.toCommaDelimitedString(allowedMethods));
    }

    public List<HttpMethod> getAccessControlAllowMethods() {
        ArrayList<HttpMethod> result = new ArrayList<HttpMethod>();
        String value = this.getFirst(ACCESS_CONTROL_ALLOW_METHODS);
        if (value != null) {
            String[] tokens;
            for (String token : tokens = StringUtils.tokenizeToStringArray((String)value, (String)",")) {
                result.add(HttpMethod.valueOf(token));
            }
        }
        return result;
    }

    public void setAccessControlAllowOrigin(String allowedOrigin) {
        this.setOrRemove(ACCESS_CONTROL_ALLOW_ORIGIN, allowedOrigin);
    }

    @Nullable
    public String getAccessControlAllowOrigin() {
        return this.getFieldValues(ACCESS_CONTROL_ALLOW_ORIGIN);
    }

    public void setAccessControlExposeHeaders(Collection<String> exposedHeaders) {
        this.setOrRemove(ACCESS_CONTROL_EXPOSE_HEADERS, this.toCommaDelimitedString(exposedHeaders));
    }

    public List<String> getAccessControlExposeHeaders() {
        return this.getValuesAsList(ACCESS_CONTROL_EXPOSE_HEADERS);
    }

    public void setAccessControlMaxAge(Duration maxAge) {
        this.setOrRemove(ACCESS_CONTROL_MAX_AGE, Long.toString(maxAge.getSeconds()));
    }

    public void setAccessControlMaxAge(long maxAge) {
        this.setOrRemove(ACCESS_CONTROL_MAX_AGE, Long.toString(maxAge));
    }

    public long getAccessControlMaxAge() {
        String value = this.getFirst(ACCESS_CONTROL_MAX_AGE);
        return value != null ? Long.parseLong(value) : -1L;
    }

    public void setAccessControlRequestHeaders(Collection<String> requestHeaders) {
        this.setOrRemove(ACCESS_CONTROL_REQUEST_HEADERS, this.toCommaDelimitedString(requestHeaders));
    }

    public List<String> getAccessControlRequestHeaders() {
        return this.getValuesAsList(ACCESS_CONTROL_REQUEST_HEADERS);
    }

    public void setAccessControlRequestMethod(@Nullable HttpMethod requestMethod) {
        this.setOrRemove(ACCESS_CONTROL_REQUEST_METHOD, requestMethod != null ? requestMethod.name() : null);
    }

    @Nullable
    public HttpMethod getAccessControlRequestMethod() {
        String first = this.getFirst(ACCESS_CONTROL_REQUEST_METHOD);
        if (StringUtils.isEmpty((CharSequence)first)) {
            return null;
        }
        return HttpMethod.valueOf(first);
    }

    public void setAcceptCharset(Collection<Charset> acceptableCharsets) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Charset charset : acceptableCharsets) {
            joiner.add(charset.name().toLowerCase(Locale.ROOT));
        }
        this.setOrRemove(ACCEPT_CHARSET, joiner.toString());
    }

    public List<Charset> getAcceptCharset() {
        String value = this.getFirst(ACCEPT_CHARSET);
        if (value != null) {
            String[] tokens = StringUtils.tokenizeToStringArray((String)value, (String)",");
            ArrayList<Charset> result = new ArrayList<Charset>(tokens.length);
            for (String token : tokens) {
                int paramIdx = token.indexOf(59);
                String charsetName = paramIdx == -1 ? token : token.substring(0, paramIdx);
                if (charsetName.equals("*")) continue;
                result.add(Charset.forName(charsetName));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public void setAllow(Collection<HttpMethod> allowedMethods) {
        this.setOrRemove(ALLOW, StringUtils.collectionToCommaDelimitedString(allowedMethods));
    }

    public void setAllow(HttpMethod ... allowedMethods) {
        this.setOrRemove(ALLOW, StringUtils.arrayToCommaDelimitedString((Object[])allowedMethods));
    }

    public void setAllow(String ... allowedMethods) {
        this.setOrRemove(ALLOW, StringUtils.arrayToCommaDelimitedString((Object[])allowedMethods));
    }

    public Set<HttpMethod> getAllow() {
        String value = this.getFirst(ALLOW);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            String[] tokens = StringUtils.tokenizeToStringArray((String)value, (String)",");
            LinkedHashSet result = CollectionUtils.newLinkedHashSet((int)tokens.length);
            for (String token : tokens) {
                HttpMethod method = HttpMethod.resolve(token);
                if (method == null) continue;
                result.add(method);
            }
            return result;
        }
        return Collections.emptySet();
    }

    public void setBasicAuth(String encodedCredentials) {
        Assert.hasText((String)encodedCredentials, (String)"'encodedCredentials' must not be null or blank");
        this.setOrRemove(AUTHORIZATION, "Basic " + encodedCredentials);
    }

    public void setBasicAuth(String username, String password) {
        this.setBasicAuth(username, password, null);
    }

    public void setBasicAuth(String username, String password, @Nullable Charset charset) {
        this.setBasicAuth(HttpHeaders.encodeBasicAuth(username, password, charset));
    }

    public void setBearerAuth(String token) {
        this.setOrRemove(AUTHORIZATION, "Bearer " + token);
    }

    public void setCacheControl(CacheControl cacheControl) {
        this.setOrRemove(CACHE_CONTROL, cacheControl.getHeaderValue());
    }

    public void setCacheControl(@Nullable String cacheControl) {
        this.setOrRemove(CACHE_CONTROL, cacheControl);
    }

    @Nullable
    public String getCacheControl() {
        return this.getFieldValues(CACHE_CONTROL);
    }

    public void setConnection(String connection) {
        this.setOrRemove(CONNECTION, connection);
    }

    public void setConnection(Collection<String> connection) {
        this.setOrRemove(CONNECTION, this.toCommaDelimitedString(connection));
    }

    public List<String> getConnection() {
        return this.getValuesAsList(CONNECTION);
    }

    public void setContentDispositionFormData(String name, @Nullable String filename) {
        Assert.notNull((Object)name, (String)"Name is required");
        ContentDisposition.Builder disposition = ContentDisposition.builder("form-data").name(name);
        if (filename != null) {
            disposition.filename(filename);
        }
        this.setContentDisposition(disposition.build());
    }

    public void setContentDisposition(ContentDisposition contentDisposition) {
        this.setOrRemove(CONTENT_DISPOSITION, contentDisposition.toString());
    }

    public void setContentDisposition(String contentDisposition) {
        this.setOrRemove(CONTENT_DISPOSITION, contentDisposition);
    }

    public ContentDisposition getContentDisposition() {
        String contentDisposition = this.getFirst(CONTENT_DISPOSITION);
        return contentDisposition != null ? ContentDisposition.parse(contentDisposition) : ContentDisposition.empty();
    }

    public void setContentLanguage(@Nullable Locale locale) {
        this.setOrRemove(CONTENT_LANGUAGE, locale != null ? locale.toLanguageTag() : null);
    }

    @Nullable
    public Locale getContentLanguage() {
        return this.getValuesAsList(CONTENT_LANGUAGE).stream().findFirst().map(Locale::forLanguageTag).orElse(null);
    }

    public void setContentLength(long contentLength) {
        this.setOrRemove(CONTENT_LENGTH, Long.toString(contentLength));
    }

    public long getContentLength() {
        String value = this.getFirst(CONTENT_LENGTH);
        return value != null ? Long.parseLong(value) : -1L;
    }

    public void setContentType(@Nullable MediaType mediaType) {
        if (mediaType != null) {
            Assert.isTrue((!mediaType.isWildcardType() ? 1 : 0) != 0, (String)"Content-Type cannot contain wildcard type '*'");
            Assert.isTrue((!mediaType.isWildcardSubtype() ? 1 : 0) != 0, (String)"Content-Type cannot contain wildcard subtype '*'");
            this.setOrRemove(CONTENT_TYPE, mediaType.toString());
        } else {
            this.remove(CONTENT_TYPE);
        }
    }

    @Nullable
    public MediaType getContentType() throws InvalidMediaTypeException {
        String value = this.getFirst(CONTENT_TYPE);
        return StringUtils.isNotEmpty((CharSequence)value) ? MediaType.parseMediaType(value) : null;
    }

    public void setDate(ZonedDateTime date) {
        this.setZonedDateTime(DATE, date);
    }

    public void setDate(Instant date) {
        this.setInstant(DATE, date);
    }

    public void setDate(long date) {
        this.setDate(DATE, date);
    }

    public long getDate() {
        return this.getFirstDate(DATE);
    }

    public void setETag(@Nullable String tag) {
        if (tag != null) {
            this.setHeader(ETAG, ETag.quoteETagIfNecessary(tag));
        } else {
            this.remove(ETAG);
        }
    }

    @Nullable
    public String getETag() {
        return this.getFirst(ETAG);
    }

    public void setExpires(ZonedDateTime expires) {
        this.setZonedDateTime(EXPIRES, expires);
    }

    public void setExpires(Instant expires) {
        this.setInstant(EXPIRES, expires);
    }

    public void setExpires(long expires) {
        this.setDate(EXPIRES, expires);
    }

    public long getExpires() {
        return this.getFirstDate(EXPIRES, false);
    }

    public void setHost(@Nullable InetSocketAddress host) {
        if (host != null) {
            Object value = host.getHostString();
            int port = host.getPort();
            if (port != 0) {
                value = (String)value + ":" + port;
            }
            this.setOrRemove(HOST, (String)value);
        } else {
            this.remove(HOST);
        }
    }

    @Nullable
    public InetSocketAddress getHost() {
        int separator;
        String value = this.getFirst(HOST);
        if (value == null) {
            return null;
        }
        String host = null;
        int port = 0;
        int n = separator = StringUtils.matchesFirst((String)value, (char)'[') ? value.indexOf(58, value.indexOf(93)) : value.lastIndexOf(58);
        if (separator != -1) {
            host = value.substring(0, separator);
            String portString = value.substring(separator + 1);
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (host == null) {
            host = value;
        }
        return InetSocketAddress.createUnresolved(host, port);
    }

    public void setIfMatch(String ifMatch) {
        this.setOrRemove(IF_MATCH, ifMatch);
    }

    public void setIfMatch(Collection<String> ifMatchList) {
        this.setOrRemove(IF_MATCH, this.toCommaDelimitedString(ifMatchList));
    }

    public List<String> getIfMatch() {
        return this.getETagValuesAsList(IF_MATCH);
    }

    public void setIfModifiedSince(ZonedDateTime ifModifiedSince) {
        this.setZonedDateTime(IF_MODIFIED_SINCE, ifModifiedSince.withZoneSameInstant(GMT));
    }

    public void setIfModifiedSince(Instant ifModifiedSince) {
        this.setInstant(IF_MODIFIED_SINCE, ifModifiedSince);
    }

    public void setIfModifiedSince(long ifModifiedSince) {
        this.setDate(IF_MODIFIED_SINCE, ifModifiedSince);
    }

    public long getIfModifiedSince() {
        return this.getFirstDate(IF_MODIFIED_SINCE, false);
    }

    public void setIfNoneMatch(@Nullable String ifNoneMatch) {
        this.setOrRemove(IF_NONE_MATCH, ifNoneMatch);
    }

    public void setIfNoneMatch(Collection<String> ifNoneMatchList) {
        this.setOrRemove(IF_NONE_MATCH, this.toCommaDelimitedString(ifNoneMatchList));
    }

    public List<String> getIfNoneMatch() {
        return this.getETagValuesAsList(IF_NONE_MATCH);
    }

    public void setIfUnmodifiedSince(ZonedDateTime ifUnmodifiedSince) {
        this.setZonedDateTime(IF_UNMODIFIED_SINCE, ifUnmodifiedSince.withZoneSameInstant(GMT));
    }

    public void setIfUnmodifiedSince(Instant ifUnmodifiedSince) {
        this.setInstant(IF_UNMODIFIED_SINCE, ifUnmodifiedSince);
    }

    public void setIfUnmodifiedSince(long ifUnmodifiedSince) {
        this.setDate(IF_UNMODIFIED_SINCE, ifUnmodifiedSince);
    }

    public long getIfUnmodifiedSince() {
        return this.getFirstDate(IF_UNMODIFIED_SINCE, false);
    }

    public void setLastModified(ZonedDateTime lastModified) {
        this.setZonedDateTime(LAST_MODIFIED, lastModified.withZoneSameInstant(GMT));
    }

    public void setLastModified(Instant lastModified) {
        this.setInstant(LAST_MODIFIED, lastModified);
    }

    public void setLastModified(long lastModified) {
        this.setDate(LAST_MODIFIED, lastModified);
    }

    public long getLastModified() {
        return this.getFirstDate(LAST_MODIFIED, false);
    }

    public void setLocation(@Nullable URI location) {
        this.setOrRemove(LOCATION, location != null ? location.toASCIIString() : null);
    }

    public void setLocation(@Nullable String location) {
        this.setOrRemove(LOCATION, location);
    }

    @Nullable
    public URI getLocation() {
        String value = this.getFirst(LOCATION);
        return value != null ? URI.create(value) : null;
    }

    public void setOrigin(@Nullable String origin) {
        this.setOrRemove(ORIGIN, origin);
    }

    @Nullable
    public String getOrigin() {
        return this.getFirst(ORIGIN);
    }

    public void setPragma(@Nullable String pragma) {
        this.setOrRemove(PRAGMA, pragma);
    }

    @Nullable
    public String getPragma() {
        return this.getFirst(PRAGMA);
    }

    public void setRange(Collection<HttpRange> ranges) {
        String value = HttpRange.toString(ranges);
        this.setOrRemove(RANGE, value);
    }

    public List<HttpRange> getRange() {
        String value = this.getFirst(RANGE);
        return HttpRange.parseRanges(value);
    }

    public void setUpgrade(String upgrade) {
        this.setOrRemove(UPGRADE, upgrade);
    }

    @Nullable
    public String getUpgrade() {
        return this.getFirst(UPGRADE);
    }

    public void setVary(Collection<String> requestHeaders) {
        this.setOrRemove(VARY, StringUtils.collectionToDelimitedString(requestHeaders, (String)", "));
    }

    public void setVary(String ... requestHeaders) {
        this.setOrRemove(VARY, StringUtils.arrayToDelimitedString((Object[])requestHeaders, (String)", "));
    }

    public List<String> getVary() {
        return this.getValuesAsList(VARY);
    }

    public void setZonedDateTime(String headerName, ZonedDateTime date) {
        this.setOrRemove(headerName, DATE_FORMATTER.format(date));
    }

    public void setInstant(String headerName, Instant date) {
        this.setZonedDateTime(headerName, ZonedDateTime.ofInstant(date, GMT));
    }

    public void setDate(String headerName, long date) {
        this.setInstant(headerName, Instant.ofEpochMilli(date));
    }

    public long getFirstDate(String headerName) {
        return this.getFirstDate(headerName, true);
    }

    public long getFirstDate(String headerName, boolean rejectInvalid) {
        ZonedDateTime zonedDateTime = this.getFirstZonedDateTime(headerName, rejectInvalid);
        return zonedDateTime != null ? zonedDateTime.toInstant().toEpochMilli() : -1L;
    }

    @Nullable
    public ZonedDateTime getFirstZonedDateTime(String headerName) {
        return this.getFirstZonedDateTime(headerName, true);
    }

    @Nullable
    public ZonedDateTime getFirstZonedDateTime(String headerName, boolean rejectInvalid) {
        String headerValue = this.getFirst(headerName);
        if (headerValue == null) {
            return null;
        }
        if (headerValue.length() >= 3) {
            int parametersIndex = headerValue.indexOf(59);
            if (parametersIndex != -1) {
                headerValue = headerValue.substring(0, parametersIndex);
            }
            for (DateTimeFormatter dateFormatter : DATE_PARSERS) {
                try {
                    return ZonedDateTime.parse(headerValue, dateFormatter);
                }
                catch (DateTimeParseException dateTimeParseException) {
                }
            }
        }
        if (rejectInvalid) {
            throw new IllegalArgumentException("Cannot parse date value \"%s\" for \"%s\" header".formatted(headerValue, headerName));
        }
        return null;
    }

    public List<String> getValuesAsList(String headerName) {
        Object values = this.get(headerName);
        if (values != null) {
            ArrayList<String> result = new ArrayList<String>();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                if (value == null) continue;
                result.addAll(HttpHeaders.tokenizeQuoted(value));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static List<String> tokenizeQuoted(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        boolean quoted = false;
        boolean trim = true;
        StringBuilder builder = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\"') {
                if (builder.isEmpty()) {
                    quoted = true;
                    continue;
                }
                if (quoted) {
                    quoted = false;
                    trim = false;
                    continue;
                }
                builder.append(ch);
                continue;
            }
            if (ch == '\\' && quoted && i < str.length() - 1) {
                builder.append(str.charAt(++i));
                continue;
            }
            if (ch == ',' && !quoted) {
                HttpHeaders.addToken(builder, tokens, trim);
                builder.setLength(0);
                trim = false;
                continue;
            }
            if (!quoted && (builder.isEmpty() || !trim) && Character.isWhitespace(ch)) continue;
            builder.append(ch);
        }
        if (!builder.isEmpty()) {
            HttpHeaders.addToken(builder, tokens, trim);
        }
        return tokens;
    }

    private static void addToken(StringBuilder builder, List<String> tokens, boolean trim) {
        String token = builder.toString();
        if (trim) {
            token = token.trim();
        }
        if (!token.isEmpty()) {
            tokens.add(token);
        }
    }

    public void clearContentHeaders() {
        this.remove(CONTENT_TYPE);
        this.remove(CONTENT_RANGE);
        this.remove(CONTENT_LENGTH);
        this.remove(CONTENT_LANGUAGE);
        this.remove(CONTENT_LOCATION);
        this.remove(CONTENT_ENCODING);
        this.remove(CONTENT_DISPOSITION);
    }

    @Unmodifiable
    public List<String> getETagValuesAsList(String name) {
        Object values = this.get(name);
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            if (value == null) continue;
            List<ETag> tags = ETag.parse(value);
            if (tags.isEmpty()) {
                throw new IllegalArgumentException("Could not parse header '%s' with value '%s'".formatted(name, value));
            }
            for (ETag tag : tags) {
                result.add(tag.formattedTag());
            }
        }
        return result;
    }

    @Nullable
    public String getFieldValues(String name) {
        return this.toCommaDelimitedString((Collection<?>)this.get(name));
    }

    @Nullable
    protected String toCommaDelimitedString(@Nullable Collection<?> value) {
        if (value == null) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (Object val : value) {
            if (val == null) continue;
            joiner.add(val.toString());
        }
        return joiner.toString();
    }

    public HttpHeaders asReadOnly() {
        return new ReadOnlyHttpHeaders(this);
    }

    public HttpHeaders asWritable() {
        return this;
    }

    public List<String> setOrRemove(String name, @Nullable String[] value) {
        return this.setOrRemove(name, value == null ? null : this.toCommaDelimitedString(Arrays.asList(value)));
    }

    public List<String> setOrRemove(String name, @Nullable Collection<String> value) {
        return this.setOrRemove(name, this.toCommaDelimitedString(value));
    }

    public List<String> setOrRemove(String name, @Nullable String value) {
        if (value != null) {
            this.setHeader(name, value);
            return null;
        }
        return this.remove(name);
    }

    public void set(String name, String value) {
        Assert.notNull((Object)name, (String)"name is required");
        Assert.notNull((Object)value, (String)"value is required");
        this.setHeader(name, value);
    }

    @Nullable
    public abstract String getFirst(String var1);

    public abstract void add(String var1, @Nullable String var2);

    protected abstract void setHeader(String var1, String var2);

    @Nullable
    public abstract List<String> get(Object var1);

    @Nullable
    public abstract List<String> remove(Object var1);

    public String toString() {
        return HttpHeaders.formatHeaders(this);
    }

    public static String formatHeaders(MultiValueMap<String, String> headers) {
        return headers.entrySet().stream().map(entry -> {
            List values = (List)entry.getValue();
            return "%s:%s".formatted(entry.getKey(), values.size() == 1 ? "\"%s\"".formatted(values.get(0)) : values.stream().map(arg_0 -> HttpHeaders.lambda$formatHeaders$2("\"%s\"", arg_0)).collect(Collectors.joining(", ")));
        }).collect(Collectors.joining(", ", "[", "]"));
    }

    public static String encodeBasicAuth(String username, String password, @Nullable Charset charset) {
        CharsetEncoder encoder;
        Assert.notNull((Object)username, (String)"Username is required");
        Assert.doesNotContain((String)username, (String)":", (String)"Username must not contain a colon");
        Assert.notNull((Object)password, (String)"Password is required");
        if (charset == null) {
            charset = StandardCharsets.ISO_8859_1;
        }
        if (!(encoder = charset.newEncoder()).canEncode(username) || !encoder.canEncode(password)) {
            throw new IllegalArgumentException("Username or password contains characters that cannot be encoded to " + charset.displayName());
        }
        String credentialsString = username + ":" + password;
        byte[] encodedBytes = Base64.getEncoder().encode(credentialsString.getBytes(charset));
        return new String(encodedBytes, charset);
    }

    @Unmodifiable
    public static HttpHeaders empty() {
        return ReadOnlyHttpHeaders.EMPTY;
    }

    @Modifiable
    public static DefaultHttpHeaders forWritable() {
        return new DefaultHttpHeaders();
    }

    @Modifiable
    public static DefaultHttpHeaders forWritable(MultiValueMap<String, String> headers) {
        return new DefaultHttpHeaders(headers);
    }

    @Unmodifiable
    public static HttpHeaders readOnlyHttpHeaders(MultiValueMap<String, String> headers) {
        return headers instanceof HttpHeaders ? ((HttpHeaders)headers).asReadOnly() : new ReadOnlyHttpHeaders(headers);
    }

    @Modifiable
    public static HttpHeaders copyOf(@Nullable Map<String, List<String>> targetMap) {
        DefaultHttpHeaders result = HttpHeaders.forWritable();
        result.addAll(targetMap);
        return result;
    }

    static String formatDate(long date) {
        Instant instant = Instant.ofEpochMilli(date);
        ZonedDateTime time = ZonedDateTime.ofInstant(instant, GMT);
        return DATE_FORMATTER.format(time);
    }

    private static /* synthetic */ String lambda$formatHeaders$2(String rec$, Object xva$0) {
        return "\"%s\"".formatted(xva$0);
    }
}

