/*
 * Decompiled with CFR 0.152.
 */
package infra.http;

import infra.http.DefaultHttpHeaders;
import infra.http.HttpHeaders;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import java.util.Map;
import java.util.Objects;

public class HttpEntity<T> {
    public static final HttpEntity<?> EMPTY = new HttpEntity();
    private final HttpHeaders headers;
    @Nullable
    private final T body;

    protected HttpEntity() {
        this(null, null);
    }

    public HttpEntity(T body) {
        this(body, null);
    }

    public HttpEntity(MultiValueMap<String, String> headers) {
        this(null, headers);
    }

    public HttpEntity(@Nullable T body, @Nullable MultiValueMap<String, String> headers) {
        DefaultHttpHeaders tempHeaders = new DefaultHttpHeaders();
        if (headers != null) {
            tempHeaders.addAll((Map)headers);
        }
        this.body = body;
        this.headers = tempHeaders;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Nullable
    public T getBody() {
        return this.body;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        HttpEntity otherEntity = (HttpEntity)other;
        return Objects.equals(this.headers, otherEntity.headers) && Objects.equals(this.body, otherEntity.body);
    }

    public int hashCode() {
        return Objects.hashCode(this.headers) * 29 + Objects.hashCode(this.body);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("<");
        if (this.body != null) {
            builder.append(this.body);
            builder.append(',');
        }
        builder.append(this.headers);
        builder.append('>');
        return builder.toString();
    }
}

