/*
 * Decompiled with CFR 0.152.
 */
package infra.http;

import infra.lang.Assert;
import infra.lang.Nullable;

public class HttpCookie {
    private final String name;
    private final String value;

    public HttpCookie(String name, @Nullable String value) {
        Assert.hasLength((String)name, (String)"'name' is required and must not be empty.");
        this.name = name;
        this.value = value != null ? value : "";
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpCookie) {
            HttpCookie otherCookie = (HttpCookie)other;
            return this.name.equalsIgnoreCase(otherCookie.getName());
        }
        return false;
    }

    public String toString() {
        return this.name + "=" + this.value;
    }
}

