/*
 * Decompiled with CFR 0.152.
 */
package infra.http;

import infra.http.HttpHeaders;
import infra.http.ReadOnlyHttpHeaders;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.LinkedCaseInsensitiveMap;
import infra.util.MultiValueMap;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;

public class DefaultHttpHeaders
extends HttpHeaders {
    private static final long serialVersionUID = 1L;
    final MultiValueMap<String, String> headers;

    public DefaultHttpHeaders() {
        this.headers = MultiValueMap.forSmartListAdaption((Map)new LinkedCaseInsensitiveMap(8, Locale.ROOT));
    }

    public DefaultHttpHeaders(Map<String, List<String>> headers) {
        this.headers = MultiValueMap.forSmartListAdaption(headers);
    }

    public DefaultHttpHeaders(MultiValueMap<String, String> headers) {
        Assert.notNull(headers, (String)"MultiValueMap is required");
        if (headers == EMPTY) {
            this.headers = MultiValueMap.forSmartListAdaption((Map)new LinkedCaseInsensitiveMap(8, Locale.ROOT));
        } else if (headers instanceof DefaultHttpHeaders) {
            MultiValueMap<String, String> multiValueMap;
            DefaultHttpHeaders httpHeaders = (DefaultHttpHeaders)headers;
            while ((multiValueMap = httpHeaders.headers) instanceof DefaultHttpHeaders) {
                DefaultHttpHeaders wrapped;
                httpHeaders = wrapped = (DefaultHttpHeaders)multiValueMap;
            }
            this.headers = httpHeaders.headers;
        } else {
            this.headers = headers;
        }
    }

    @Override
    public String getFirst(String name) {
        return (String)this.headers.getFirst((Object)name);
    }

    @Override
    public void add(String name, @Nullable String value) {
        this.headers.add((Object)name, (Object)value);
    }

    @Override
    protected void setHeader(String name, String value) {
        this.headers.setOrRemove((Object)name, (Object)value);
    }

    @Override
    @Nullable
    public List<String> setOrRemove(String name, @Nullable Collection<String> value) {
        return this.headers.setOrRemove((Object)name, value);
    }

    @Override
    @Nullable
    public List<String> setOrRemove(String name, @Nullable String[] value) {
        return this.headers.setOrRemove((Object)name, (Object[])value);
    }

    @Override
    public List<String> remove(Object name) {
        return (List)this.headers.remove(name);
    }

    public int size() {
        return this.headers.size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.headers.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    @Override
    public List<String> get(Object name) {
        return (List)this.headers.get(name);
    }

    public List<String> put(String key, List<String> value) {
        return (List)this.headers.put((Object)key, value);
    }

    public void putAll(Map<? extends String, ? extends List<String>> m) {
        this.headers.putAll(m);
    }

    public void clear() {
        this.headers.clear();
    }

    public Set<String> keySet() {
        return this.headers.keySet();
    }

    public Collection<List<String>> values() {
        return this.headers.values();
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.headers.entrySet();
    }

    public Map<String, String> toSingleValueMap() {
        return this.headers.toSingleValueMap();
    }

    public Map<String, String[]> toArrayMap(IntFunction<String[]> mappingFunction) {
        return this.headers.toArrayMap(mappingFunction);
    }

    public void copyToArrayMap(Map<String, String[]> newMap, IntFunction<String[]> function) {
        this.headers.copyToArrayMap(newMap, function);
    }

    public void forEach(BiConsumer<? super String, ? super List<String>> action) {
        this.headers.forEach(action);
    }

    public List<String> putIfAbsent(String key, List<String> value) {
        return (List)this.headers.putIfAbsent((Object)key, value);
    }

    @Override
    public HttpHeaders asReadOnly() {
        return new ReadOnlyHttpHeaders(this.headers);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefaultHttpHeaders)) {
            return false;
        }
        return DefaultHttpHeaders.unwrap(this).equals(DefaultHttpHeaders.unwrap((DefaultHttpHeaders)other));
    }

    private static MultiValueMap<String, String> unwrap(DefaultHttpHeaders headers) {
        while (headers.headers instanceof DefaultHttpHeaders) {
            headers = (DefaultHttpHeaders)headers.headers;
        }
        return headers.headers;
    }

    public int hashCode() {
        return this.headers.hashCode();
    }
}

