/*
 * Copyright 2017 - 2024 the original author or authors.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see [https://www.gnu.org/licenses/]
 */

package cn.taketoday.http.client;

import java.io.IOException;
import java.net.URI;

import cn.taketoday.http.HttpMethod;

/**
 * Factory for {@link ClientHttpRequest} objects.
 * Requests are created by the {@link #createRequest(URI, HttpMethod)} method.
 *
 * @author Arjen Poutsma
 * @author <a href="https://github.com/TAKETODAY">Harry Yang</a>
 * @since 4.0
 */
@FunctionalInterface
public interface ClientHttpRequestFactory {

  /**
   * Create a new {@link ClientHttpRequest} for the specified URI and HTTP method.
   * <p>The returned request can be written to, and then executed by calling
   * {@link ClientHttpRequest#execute()}.
   *
   * @param uri the URI to create a request for
   * @param httpMethod the HTTP method to execute
   * @return the created request
   * @throws IOException in case of I/O errors
   */
  ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException;

}
