/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.view;

import cn.taketoday.context.annotation.Value;
import cn.taketoday.context.factory.InitializingBean;
import cn.taketoday.web.view.AbstractViewResolver;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.WebContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.ServletContextTemplateResolver;

public class ThymeleafViewResolver
extends AbstractViewResolver
implements InitializingBean {
    private TemplateEngine templateEngine;
    @Value(value="#{thymeleaf.cacheable}", required=false)
    private boolean cacheable = true;

    public void afterPropertiesSet() throws Exception {
        this.templateEngine = new TemplateEngine();
        ServletContextTemplateResolver templateResolver = new ServletContextTemplateResolver(this.servletContext);
        templateResolver.setPrefix(this.prefix);
        templateResolver.setSuffix(this.suffix);
        templateResolver.setCacheable(this.cacheable);
        templateResolver.setCharacterEncoding(this.encoding);
        templateResolver.setTemplateMode(TemplateMode.HTML);
        this.templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
        LoggerFactory.getLogger(this.getClass()).info("Configuration Thymeleaf View Resolver Success.");
    }

    @Override
    public void resolveView(String templateName, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        this.templateEngine.process(templateName, (IContext)new WebContext(request, response, this.servletContext, this.locale), (Writer)response.getWriter());
    }
}

