/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.view;

import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.factory.InitializingBean;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.web.view.AbstractViewResolver;
import java.util.Map;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.LoggerFactory;

public class JstlViewResolver
extends AbstractViewResolver
implements InitializingBean {
    @Override
    public void resolveView(String templateName, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        request.getRequestDispatcher(this.prefix + templateName + this.suffix).forward((ServletRequest)request, (ServletResponse)response);
    }

    public void afterPropertiesSet() throws Exception {
        String jspServlet = "org.apache.jasper.servlet.JspServlet";
        if (!ClassUtils.isPresent((String)"org.apache.jasper.servlet.JspServlet")) {
            throw new ConfigurationException("You must provide: [] to your application's class path", new Object[]{"org.apache.jasper.servlet.JspServlet"});
        }
        boolean register = true;
        for (Map.Entry entry : this.servletContext.getServletRegistrations().entrySet()) {
            if (!"org.apache.jasper.servlet.JspServlet".equals(((ServletRegistration)entry.getValue()).getClassName())) continue;
            register = false;
            break;
        }
        if (!register) {
            ServletRegistration.Dynamic servletRegistration = this.servletContext.addServlet("jsp", "org.apache.jasper.servlet.JspServlet");
            servletRegistration.addMapping(new String[]{"*.jsp", "*.jspx"});
        }
        LoggerFactory.getLogger(this.getClass()).info("Configuration Jstl View Resolver Success.");
    }
}

