/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.view;

import cn.taketoday.context.annotation.Autowired;
import cn.taketoday.context.annotation.Props;
import cn.taketoday.context.annotation.Singleton;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.factory.InitializingBean;
import cn.taketoday.web.annotation.WebDebugMode;
import cn.taketoday.web.view.AbstractViewResolver;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.AllHttpScopesHashModel;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.HttpRequestParametersHashModel;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.Writer;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.LoggerFactory;

@WebDebugMode
@Props(prefix={"web.mvc.view."})
@Singleton(value={"viewResolver"})
public class FreeMarkerViewResolver
extends AbstractViewResolver
implements InitializingBean {
    @Autowired(required=false)
    private ObjectWrapper wrapper;
    @Autowired(required=false)
    private Configuration configuration;
    @Autowired(required=false)
    private TaglibFactory taglibFactory;
    @Props(prefix={"freemarker."}, replace=true)
    private Properties settings;
    private ServletContextHashModel applicationModel;

    public void afterPropertiesSet() throws ConfigurationException {
        if (this.configuration == null) {
            this.configuration = new Configuration(Configuration.VERSION_2_3_28);
            if (this.wrapper == null) {
                this.wrapper = new DefaultObjectWrapper(Configuration.VERSION_2_3_28);
            }
            if (this.taglibFactory == null) {
                this.taglibFactory = new TaglibFactory(this.servletContext);
            }
            this.configuration.setLocale(this.locale);
            this.configuration.setObjectWrapper(this.wrapper);
            this.configuration.setDefaultEncoding(this.encoding);
            this.configuration.setServletContextForTemplateLoading((Object)this.servletContext, this.prefix);
            try {
                if (this.settings != null) {
                    this.configuration.setSettings(this.settings);
                }
                this.applicationModel = new ServletContextHashModel(this.servletContext, this.wrapper);
            }
            catch (TemplateException e) {
                throw new ConfigurationException("Set FreeMarker's Properties Error, With Msg: [{}]", new Object[]{e.getMessage(), e});
            }
        }
        LoggerFactory.getLogger(this.getClass()).info("Configuration FreeMarker View Resolver Success.");
    }

    private final TemplateHashModel createModel(final HttpServletRequest request, final HttpServletResponse response) throws TemplateModelException {
        final ObjectWrapper wrapper = this.wrapper;
        return new AllHttpScopesHashModel(wrapper, this.servletContext, request){
            {
                super(x0, x1, x2);
                this.putUnlistedModel("JspTaglibs", (TemplateModel)FreeMarkerViewResolver.this.taglibFactory);
                this.putUnlistedModel("Application", (TemplateModel)FreeMarkerViewResolver.this.applicationModel);
                this.putUnlistedModel("Request", (TemplateModel)new HttpRequestHashModel(request, response, wrapper));
                this.putUnlistedModel("RequestParameters", (TemplateModel)new HttpRequestParametersHashModel(request));
                this.putUnlistedModel("Session", (TemplateModel)new HttpSessionHashModel(request.getSession(), wrapper));
            }
        };
    }

    @Override
    public void resolveView(String templateName, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        this.configuration.getTemplate(templateName + this.suffix, this.locale, this.encoding).process((Object)this.createModel(request, response), (Writer)response.getWriter());
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

