/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.utils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class ParamList<E>
implements List<E>,
RandomAccess,
Serializable {
    private Object[] array = new Object[0];

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static int indexOf(Object o, Object[] elements, int index, int fence) {
        if (o == null) {
            for (int i = index; i < fence; ++i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i < fence; ++i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static int lastIndexOf(Object o, Object[] elements, int index) {
        if (o == null) {
            for (int i = index; i >= 0; --i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i >= 0; --i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return ParamList.indexOf(o, this.array, 0, this.array.length) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        return ParamList.indexOf(o, this.array, 0, this.array.length);
    }

    public int indexOf(E e, int index) {
        return ParamList.indexOf(e, this.array, index, this.array.length);
    }

    @Override
    public int lastIndexOf(Object o) {
        return ParamList.lastIndexOf(o, this.array, this.array.length - 1);
    }

    public int lastIndexOf(E e, int index) {
        return ParamList.lastIndexOf(e, this.array, index);
    }

    @Override
    public Object[] toArray() {
        return this.array;
    }

    @Override
    public E get(int index) {
        return (E)(index > this.array.length - 1 ? null : this.array[index]);
    }

    @Override
    public E set(int index, E element) {
        if (index <= this.array.length - 1) {
            Object oldElement = this.array[index];
            this.array[index] = element;
            return (E)oldElement;
        }
        Object[] newArray = new Object[index + 1];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        newArray[index] = element;
        this.array = newArray;
        return element;
    }

    @Override
    public boolean add(E e) {
        Object[] newArray = new Object[this.array.length + 1];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        newArray[this.array.length] = e;
        this.array = newArray;
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (index <= this.array.length - 1) {
            this.array[index] = element;
            return;
        }
        Object[] newArray = new Object[index + 1];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        newArray[index] = element;
        this.array = newArray;
    }

    @Override
    public E remove(int index) {
        Object[] elements = this.array;
        E oldValue = this.get(index);
        int numMoved = this.array.length - index - 1;
        if (numMoved == 0) {
            this.array = Arrays.copyOf(elements, this.array.length - 1);
        } else {
            Object[] newElements = new Object[this.array.length - 1];
            System.arraycopy(elements, 0, newElements, 0, index);
            System.arraycopy(elements, index + 1, newElements, index, numMoved);
            this.array = newElements;
        }
        return oldValue;
    }

    @Override
    public boolean remove(Object o) {
        Object[] snapshot = this.array;
        int index = ParamList.indexOf(o, snapshot, 0, snapshot.length);
        return index < 0 ? false : this.remove(o, snapshot, index);
    }

    private boolean remove(Object o, Object[] snapshot, int index) {
        block4: {
            if (snapshot != this.array) {
                int prefix = Math.min(index, this.array.length);
                for (int i = 0; i < prefix; ++i) {
                    if (this.array[i] == snapshot[i] || !ParamList.eq(o, this.array[i])) continue;
                    index = i;
                    break block4;
                }
                if (index >= this.array.length) {
                    return false;
                }
                if (this.array[index] != o && (index = ParamList.indexOf(o, this.array, index, this.array.length)) < 0) {
                    return false;
                }
            }
        }
        Object[] newElements = new Object[this.array.length - 1];
        System.arraycopy(this.array, 0, newElements, 0, index);
        System.arraycopy(this.array, index + 1, newElements, index, this.array.length - index - 1);
        this.array = newElements;
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (ParamList.indexOf(e, this.array, 0, this.array.length) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.array = new Object[0];
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] cs;
        Object[] objectArray = cs = c.getClass() == ParamList.class ? ((ParamList)c).array : c.toArray();
        if (cs.length == 0) {
            return false;
        }
        if (this.array.length == 0 && cs.getClass() == Object[].class) {
            this.array = cs;
        } else {
            Object[] newElements = Arrays.copyOf(this.array, this.array.length + cs.length);
            System.arraycopy(cs, 0, newElements, this.array.length, cs.length);
            this.array = newElements;
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Object[] newElements;
        Object[] cs = c.toArray();
        if (index > this.array.length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.array.length);
        }
        if (cs.length == 0) {
            return false;
        }
        int numMoved = this.array.length - index;
        if (numMoved == 0) {
            newElements = Arrays.copyOf(this.array, this.array.length + cs.length);
        } else {
            newElements = new Object[this.array.length + cs.length];
            System.arraycopy(this.array, 0, newElements, 0, index);
            System.arraycopy(this.array, index, newElements, index + cs.length, numMoved);
        }
        System.arraycopy(cs, 0, newElements, index, cs.length);
        this.array = newElements;
        return true;
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.array.length; ++i) {
            Object e = this.array[i];
            action.accept(e);
        }
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.array.length != 0) {
            int newlen = 0;
            Object[] temp = new Object[this.array.length];
            for (int i = 0; i < this.array.length; ++i) {
                Object e = this.array[i];
                if (filter.test(e)) continue;
                temp[newlen++] = e;
            }
            if (newlen != this.array.length) {
                this.array = Arrays.copyOf(temp, newlen);
                return true;
            }
        }
        return false;
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        if (operator == null) {
            throw new NullPointerException();
        }
        Object[] newElements = Arrays.copyOf(this.array, this.array.length);
        for (int i = 0; i < this.array.length; ++i) {
            Object e = this.array[i];
            newElements[i] = operator.apply(e);
        }
        this.array = newElements;
    }

    @Override
    public void sort(Comparator<? super E> c) {
        Object[] newElements;
        Object[] es = newElements = Arrays.copyOf(this.array, this.array.length);
        Arrays.sort(es, c);
        this.array = newElements;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        Iterator it = list.iterator();
        for (int i = 0; i < this.array.length; ++i) {
            if (it.hasNext() && ParamList.eq(this.array[i], it.next())) continue;
            return false;
        }
        return !it.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.array.length; ++i) {
            Object obj = this.array[i];
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    public Iterator<E> iterator() {
        return new COWIterator(this.array, 0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new COWIterator(this.array, 0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.array.length) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new COWIterator(this.array, index);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.array, 1040);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public int addAllAbsent(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    static final class COWIterator<E>
    implements ListIterator<E> {
        private final Object[] snapshot;
        private int cursor;

        private COWIterator(Object[] elements, int initialCursor) {
            this.cursor = initialCursor;
            this.snapshot = elements;
        }

        @Override
        public final boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        @Override
        public final boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[this.cursor++];
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[--this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            Object[] elements = this.snapshot;
            int size = elements.length;
            for (int i = this.cursor; i < size; ++i) {
                Object e = elements[i];
                action.accept(e);
            }
            this.cursor = size;
        }
    }
}

