/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.ui;

import cn.taketoday.web.ui.Model;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ModelAttributes
implements Model,
Map<String, Object> {
    private final HttpServletRequest request;

    public ModelAttributes(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public ModelAttributes addAttribute(String attributeName, Object attributeValue) {
        if (attributeName != null) {
            this.request.setAttribute(attributeName, attributeValue);
        }
        return this;
    }

    @Override
    public ModelAttributes addAllAttributes(Map<String, Object> attributes) {
        attributes.forEach((arg_0, arg_1) -> ((HttpServletRequest)this.request).setAttribute(arg_0, arg_1));
        return this;
    }

    @Override
    public boolean containsAttribute(String attributeName) {
        return this.request.getAttribute(attributeName) == null;
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration attributeNames = this.request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            map.put(name, this.request.getAttribute(name));
        }
        return map;
    }

    @Override
    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    @Override
    public Collection<String> getAttributeNames() {
        Enumeration enumeration = this.request.getAttributeNames();
        HashSet<String> attributeNames = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            attributeNames.add((String)enumeration.nextElement());
        }
        return attributeNames;
    }

    @Override
    public int size() {
        int size = 0;
        while (this.request.getAttributeNames().hasMoreElements()) {
            ++size;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsAttribute((String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            throw new RuntimeException("Attribute name must be a String");
        }
        return this.request.getAttribute((String)key);
    }

    @Override
    public Object put(String key, Object value) {
        this.request.setAttribute(key, value);
        return null;
    }

    @Override
    public Object remove(Object name) {
        if (!(name instanceof String)) {
            throw new RuntimeException("Attribute name must be a String");
        }
        this.request.removeAttribute((String)name);
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> attributes) {
        this.addAllAttributes(attributes);
    }

    @Override
    public void clear() {
        Enumeration attributeNames = this.request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            this.request.removeAttribute((String)attributeNames.nextElement());
        }
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        Enumeration attributeNames = this.request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            keySet.add((String)attributeNames.nextElement());
        }
        return keySet;
    }

    @Override
    public Collection<Object> values() {
        HashSet<Object> valueSet = new HashSet<Object>();
        Enumeration attributeNames = this.request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            valueSet.add(this.request.getAttribute((String)attributeNames.nextElement()));
        }
        return valueSet;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>();
        Enumeration attributeNames = this.request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String currentKey = (String)attributeNames.nextElement();
            entries.add(new Node(currentKey, this.request.getAttribute(currentKey)));
        }
        return entries;
    }

    @Override
    public Object getAttribute(String name) {
        return this.get(name);
    }

    @Override
    public <T> T getAttribute(String name, Class<T> targetClass) {
        return targetClass.cast(this.get(name));
    }

    private static final class Node
    implements Map.Entry<String, Object> {
        private final String key;
        private Object value;

        public Node(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public final Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public final Object getValue() {
            return this.value;
        }

        @Override
        public final String getKey() {
            return this.key;
        }
    }
}

