/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.servlet;

import cn.taketoday.context.annotation.Autowired;
import cn.taketoday.context.annotation.Value;
import cn.taketoday.context.utils.ExceptionUtils;
import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.web.mapping.ViewMapping;
import cn.taketoday.web.resolver.ExceptionResolver;
import cn.taketoday.web.servlet.DispatcherServlet;
import cn.taketoday.web.view.ViewResolver;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewDispatcher
extends GenericServlet {
    private final Logger log = LoggerFactory.getLogger(ViewDispatcher.class);
    @Autowired(value="viewResolver")
    protected ViewResolver viewResolver;
    @Autowired(value="exceptionResolver")
    private ExceptionResolver exceptionResolver;
    @Value(value="#{download.buff.size}", required=false)
    private int downloadFileBuf = 10240;
    private static final Map<String, ViewMapping> VIEW_REQUEST_MAPPING = new HashMap<String, ViewMapping>(16, 1.0f);

    public static final Map<String, ViewMapping> getMappings() {
        return VIEW_REQUEST_MAPPING;
    }

    public static final void register(String name, ViewMapping viewMapping) {
        VIEW_REQUEST_MAPPING.put(name, viewMapping);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        ViewMapping mapping = VIEW_REQUEST_MAPPING.get(request.getRequestURI());
        try {
            if (mapping == null) {
                response.sendError(404);
                this.log.debug("NOT FOUND -> [{}]", (Object)request.getRequestURI());
                return;
            }
            Object result = null;
            if (mapping.hasAction()) {
                result = mapping.getAction().invoke(mapping.getController(), request, response);
            }
            if (response.isCommitted()) {
                return;
            }
            String contentType = mapping.getContentType();
            if (StringUtils.isNotEmpty((String)contentType)) {
                response.setContentType(contentType);
            }
            switch (mapping.getReturnType()) {
                case 1: {
                    this.viewResolver.resolveView(mapping.getAssetsPath(), request, response);
                    return;
                }
                case 2: {
                    response.sendRedirect(mapping.getAssetsPath());
                    return;
                }
                case 4: {
                    DispatcherServlet.resolveImage(response, (RenderedImage)result);
                    return;
                }
                case 5: {
                    response.getWriter().print(result);
                    break;
                }
                case 7: {
                    DispatcherServlet.resolveObject(request, response, result, this.viewResolver, this.downloadFileBuf);
                }
            }
        }
        catch (Throwable exception) {
            try {
                exception = ExceptionUtils.unwrapThrowable((Throwable)exception);
                this.exceptionResolver.resolveException(request, response, exception, null);
                this.log("Catch Throwable: [" + exception + "] With Msg: [" + exception.getMessage() + "]", exception);
            }
            catch (Throwable e) {
                this.log("Handling of [" + exception.getClass().getName() + "]  resulted in Exception: [" + e.getClass().getName() + "]", e);
                throw new ServletException(e);
            }
        }
    }

    public String getServletInfo() {
        return "ViewDispatcher, Copyright \u00a9 Today & 2017 - 2018 All Rights Reserved";
    }
}

