/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.servlet;

import cn.taketoday.context.annotation.Autowired;
import cn.taketoday.context.annotation.Value;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.factory.InitializingBean;
import cn.taketoday.context.utils.ExceptionUtils;
import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.web.WebApplicationContext;
import cn.taketoday.web.WebApplicationContextAware;
import cn.taketoday.web.mapping.HandlerInterceptorRegistry;
import cn.taketoday.web.mapping.HandlerMapping;
import cn.taketoday.web.mapping.HandlerMappingRegistry;
import cn.taketoday.web.mapping.HandlerMethod;
import cn.taketoday.web.mapping.MethodParameter;
import cn.taketoday.web.mapping.RegexMapping;
import cn.taketoday.web.resolver.ExceptionResolver;
import cn.taketoday.web.resolver.ParameterResolver;
import cn.taketoday.web.ui.ModelAndView;
import cn.taketoday.web.view.AbstractViewResolver;
import cn.taketoday.web.view.ViewResolver;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherServlet
implements Servlet,
InitializingBean,
WebApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DispatcherServlet.class);
    @Autowired(value="viewResolver")
    private ViewResolver viewResolver;
    @Autowired(value="parameterResolver")
    private ParameterResolver parameterResolver;
    @Autowired(value="exceptionResolver")
    private ExceptionResolver exceptionResolver;
    private String contextPath;
    @Value(value="#{download.buff.size}", required=false)
    private int downloadFileBuf = 10240;
    @Autowired(value="handlerMappingRegistry")
    private HandlerMappingRegistry handlerMappingRegistry;
    @Autowired(value="handlerInterceptorRegistry")
    private HandlerInterceptorRegistry handlerInterceptorRegistry;
    private WebApplicationContext applicationContext;
    private ServletConfig servletConfig;
    @Value(value="#{fastjson.features}", required=false)
    private static SerializerFeature[] SERIALIZE_FEATURES = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.DisableCircularReferenceDetect};

    public void afterPropertiesSet() {
        if (this.applicationContext == null) {
            throw new ConfigurationException("An unexpected error occurred, 'applicationContext' can't be null");
        }
        if (this.exceptionResolver == null) {
            throw new ConfigurationException("You must provide an 'exceptionResolver'");
        }
        if (this.parameterResolver == null) {
            throw new ConfigurationException("You must provide a 'parameterResolver'");
        }
        if (this.viewResolver instanceof AbstractViewResolver) {
            JSON.defaultLocale = ((AbstractViewResolver)this.viewResolver).getLocale();
        }
        this.contextPath = this.applicationContext.getServletContext().getContextPath();
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HandlerMapping requestMapping = null;
        try {
            String requestURI = request.getMethod() + request.getRequestURI();
            HandlerMappingRegistry handlerMappingRegistry = this.getHandlerMappingRegistry();
            Integer index = handlerMappingRegistry.getIndex(requestURI);
            if (index == null) {
                requestURI = StringUtils.decodeUrl((String)requestURI);
                for (RegexMapping regexMapping : handlerMappingRegistry.getRegexMappings()) {
                    if (!requestURI.matches(regexMapping.getRegex())) continue;
                    index = regexMapping.getIndex();
                    break;
                }
                if (index == null) {
                    log.debug("NOT FOUND -> [{}]", (Object)requestURI);
                    response.sendError(404);
                    return;
                }
            }
            request.setAttribute("REQUESTURI", (Object)requestURI);
            requestMapping = handlerMappingRegistry.get(index);
            Integer[] interceptors = requestMapping.getInterceptors();
            HandlerInterceptorRegistry handlerInterceptorRegistry = this.getHandlerInterceptorRegistry();
            for (Integer interceptor : interceptors) {
                if (handlerInterceptorRegistry.get(interceptor).beforeProcess(request, response, requestMapping)) continue;
                log.debug("Interceptor: [{}] return false", (Object)handlerInterceptorRegistry.get(interceptor));
                return;
            }
            HandlerMethod handlerMethod = requestMapping.getHandlerMethod();
            MethodParameter[] methodParameters = handlerMethod.getParameter();
            Object[] args = new Object[methodParameters.length];
            this.parameterResolver.resolveParameter(args, methodParameters, request, response);
            Object result = handlerMethod.getMethod().invoke(requestMapping.getAction(), args);
            for (Integer interceptor : interceptors) {
                handlerInterceptorRegistry.get(interceptor).afterProcess(result, request, response);
            }
            switch (handlerMethod.getReutrnType()) {
                case 2: {
                    DispatcherServlet.resolveView(request, response, (String)result, this.contextPath, this.viewResolver);
                    break;
                }
                case 5: {
                    response.getWriter().print(result);
                    break;
                }
                case 3: {
                    DispatcherServlet.downloadFile(request, response, (File)result, this.downloadFileBuf);
                    break;
                }
                case 4: {
                    ImageIO.write((RenderedImage)result, "png", (OutputStream)response.getOutputStream());
                    break;
                }
                case 1: {
                    DispatcherServlet.resolveJsonView(response, result);
                    break;
                }
                case 6: {
                    this.resolveModelAndView(request, response, (ModelAndView)result);
                    break;
                }
                case 0: {
                    Object attribute = request.getAttribute("MODELANDVIEW");
                    if (attribute == null) break;
                    this.resolveModelAndView(request, response, (ModelAndView)attribute);
                    break;
                }
                case 7: {
                    DispatcherServlet.resolveObject(request, response, result, this.viewResolver, this.downloadFileBuf);
                }
            }
        }
        catch (Throwable exception) {
            try {
                exception = ExceptionUtils.unwrapThrowable((Throwable)exception);
                this.exceptionResolver.resolveException(request, response, exception, requestMapping);
                this.log("Catch Throwable: [" + exception + "] With Msg: [" + exception.getMessage() + "]", exception);
            }
            catch (Throwable e) {
                this.log("Handling of [" + exception.getClass().getName() + "]  resulted in Exception: [" + e.getClass().getName() + "]", e);
                throw new ServletException(e);
            }
        }
    }

    static void resolveView(HttpServletRequest request, HttpServletResponse response, String resource, String contextPath, ViewResolver viewResolver) throws Throwable {
        DispatcherServlet.resolveView(request, response, resource, contextPath, viewResolver, null);
    }

    static void resolveView(HttpServletRequest request, HttpServletResponse response, String resource, String contextPath, ViewResolver viewResolver, Map<String, Object> dataModel) throws Throwable {
        HttpSession session;
        Object attribute;
        if (resource.startsWith("redirect:")) {
            String redirect = resource.replaceFirst("redirect:", "");
            if (redirect.startsWith("http")) {
                response.sendRedirect(redirect);
                return;
            }
            response.sendRedirect(contextPath + redirect);
            return;
        }
        if (dataModel != null) {
            dataModel.forEach((arg_0, arg_1) -> ((HttpServletRequest)request).setAttribute(arg_0, arg_1));
        }
        if ((attribute = (session = request.getSession()).getAttribute("REDIRECTMODEL")) != null) {
            ((Map)attribute).forEach((arg_0, arg_1) -> ((HttpServletRequest)request).setAttribute(arg_0, arg_1));
            session.removeAttribute("REDIRECTMODEL");
        }
        viewResolver.resolveView(resource, request, response);
    }

    void resolveModelAndView(HttpServletRequest request, HttpServletResponse response, ModelAndView modelAndView) throws Throwable {
        Object view;
        if (modelAndView.noView()) {
            return;
        }
        String contentType = modelAndView.getContentType();
        if (StringUtils.isNotEmpty((String)contentType)) {
            response.setContentType(contentType);
        }
        if ((view = modelAndView.getView()) instanceof String) {
            DispatcherServlet.resolveView(request, response, (String)view, this.contextPath, this.viewResolver, modelAndView.getDataModel());
        } else if (view instanceof StringBuilder || view instanceof StringBuffer) {
            response.getWriter().print(view.toString());
        } else if (view instanceof File) {
            DispatcherServlet.downloadFile(request, response, (File)view, this.downloadFileBuf);
        } else if (view instanceof RenderedImage) {
            DispatcherServlet.resolveImage(response, (RenderedImage)view);
        } else {
            DispatcherServlet.resolveJsonView(response, view);
        }
    }

    static void resolveJsonView(HttpServletResponse response, Object view) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        JSON.writeJSONString((Writer)response.getWriter(), (Object)view, (SerializerFeature[])SERIALIZE_FEATURES);
    }

    static void resolveImage(HttpServletResponse response, RenderedImage image) throws IOException {
        ImageIO.write(image, "png", (OutputStream)response.getOutputStream());
    }

    static void downloadFile(HttpServletRequest request, HttpServletResponse response, File download, int downloadFileBuf) throws IOException {
        response.setContentLengthLong(download.length());
        response.setContentType("application/force-download;");
        response.setHeader("Content-Transfer-Encoding", "binary");
        response.setHeader("Content-Disposition", "attachment;filename=\"" + StringUtils.encodeUrl((String)download.getName()) + "\"");
        try (FileInputStream in = new FileInputStream(download);
             ServletOutputStream out = response.getOutputStream();){
            byte[] buff = new byte[downloadFileBuf];
            int len = 0;
            while ((len = ((InputStream)in).read(buff)) != -1) {
                out.write(buff, 0, len);
            }
        }
    }

    static void resolveObject(HttpServletRequest request, HttpServletResponse response, Object result, ViewResolver viewResolver, int downloadFileBuf) throws Throwable {
        if (result instanceof String) {
            DispatcherServlet.resolveView(request, response, (String)result, request.getContextPath(), viewResolver);
            return;
        }
        if (result instanceof StringBuilder || result instanceof StringBuffer) {
            response.getWriter().print(result.toString());
            return;
        }
        if (result instanceof RenderedImage) {
            DispatcherServlet.resolveImage(response, (RenderedImage)result);
            return;
        }
        if (result instanceof File) {
            DispatcherServlet.downloadFile(request, response, (File)result, downloadFileBuf);
            return;
        }
        DispatcherServlet.resolveJsonView(response, result);
    }

    @Override
    public void setWebApplicationContext(WebApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    final void log(String message, Throwable t) {
        this.applicationContext.getServletContext().log(this.getServletName() + ": " + message, t);
    }

    final void log(String msg) {
        this.applicationContext.getServletContext().log(this.getServletName() + ": " + msg);
    }

    public String getServletName() {
        return "DispatcherServlet";
    }

    public String getServletInfo() {
        return "DispatcherServlet, Copyright \u00a9 Today & 2017 - 2018 All Rights Reserved";
    }

    public void destroy() {
        if (this.applicationContext != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String msg = new StringBuffer().append("Your application destroyed at: [").append(simpleDateFormat.format(new Date())).append("] on startup date: [").append(simpleDateFormat.format(this.applicationContext.getStartupDate())).append("]").toString();
            this.applicationContext.close();
            log.info(msg);
            this.applicationContext.getServletContext().log(msg);
        }
    }

    final HandlerInterceptorRegistry getHandlerInterceptorRegistry() {
        return this.handlerInterceptorRegistry;
    }

    final HandlerMappingRegistry getHandlerMappingRegistry() {
        return this.handlerMappingRegistry;
    }

    final String getContextPath() {
        return this.contextPath;
    }

    final int getDownloadFileBuf() {
        return this.downloadFileBuf;
    }

    final ViewResolver getViewResolver() {
        return this.viewResolver;
    }

    final ExceptionResolver getExceptionResolver() {
        return this.exceptionResolver;
    }

    final ParameterResolver getParameterResolver() {
        return this.parameterResolver;
    }
}

