/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.servlet;

import cn.taketoday.context.annotation.Singleton;
import cn.taketoday.context.utils.ExceptionUtils;
import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.web.annotation.WebDebugMode;
import cn.taketoday.web.interceptor.HandlerInterceptor;
import cn.taketoday.web.mapping.HandlerInterceptorRegistry;
import cn.taketoday.web.mapping.HandlerMapping;
import cn.taketoday.web.mapping.HandlerMappingRegistry;
import cn.taketoday.web.mapping.HandlerMethod;
import cn.taketoday.web.mapping.MethodParameter;
import cn.taketoday.web.mapping.RegexMapping;
import cn.taketoday.web.servlet.DispatcherServlet;
import cn.taketoday.web.ui.ModelAndView;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebDebugMode
@Singleton(value={"dispatcherServlet"})
public class DebugDispatcherServlet
extends DispatcherServlet {
    private final Logger log = LoggerFactory.getLogger(DebugDispatcherServlet.class);

    @Override
    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException {
        long start = System.currentTimeMillis();
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HandlerMapping requestMapping = null;
        try {
            String requestURI = request.getMethod() + request.getRequestURI();
            HandlerMappingRegistry handlerMappingRegistry = this.getHandlerMappingRegistry();
            Integer index = handlerMappingRegistry.getIndex(requestURI);
            if (index == null) {
                requestURI = StringUtils.decodeUrl((String)requestURI);
                for (RegexMapping regexMapping : handlerMappingRegistry.getRegexMappings()) {
                    if (!requestURI.matches(regexMapping.getRegex())) continue;
                    index = regexMapping.getIndex();
                    break;
                }
                if (index == null) {
                    this.log.debug("NOT FOUND -> [{}]", (Object)requestURI);
                    response.sendError(404);
                    return;
                }
            }
            request.setAttribute("REQUESTURI", (Object)requestURI);
            requestMapping = handlerMappingRegistry.get(index);
            Integer[] interceptors = requestMapping.getInterceptors();
            HandlerInterceptorRegistry handlerInterceptorRegistry = this.getHandlerInterceptorRegistry();
            for (Integer interceptor : interceptors) {
                if (handlerInterceptorRegistry.get(interceptor).beforeProcess(request, response, requestMapping)) continue;
                this.log.debug("Before HandlerMethod Process: [{}] return false", (Object)handlerInterceptorRegistry.get(interceptor));
                return;
            }
            HandlerMethod handlerMethod = requestMapping.getHandlerMethod();
            MethodParameter[] methodParameters = handlerMethod.getParameter();
            Object[] args = new Object[methodParameters.length];
            this.getParameterResolver().resolveParameter(args, methodParameters, request, response);
            this.log.debug("Parameter list: {}", (Object)Arrays.toString(args));
            Object result = handlerMethod.getMethod().invoke(requestMapping.getAction(), args);
            for (Integer interceptor : interceptors) {
                HandlerInterceptor handlerInterceptor = handlerInterceptorRegistry.get(interceptor);
                handlerInterceptor.afterProcess(result, request, response);
                this.log.debug("After HandlerMethod Process: [{}]", (Object)handlerInterceptor);
            }
            switch (handlerMethod.getReutrnType()) {
                case 2: {
                    DebugDispatcherServlet.resolveView(request, response, (String)result, this.getContextPath(), this.getViewResolver());
                    break;
                }
                case 5: {
                    response.getWriter().print(result);
                    break;
                }
                case 3: {
                    DebugDispatcherServlet.downloadFile(request, response, (File)result, this.getDownloadFileBuf());
                    break;
                }
                case 4: {
                    ImageIO.write((RenderedImage)result, "png", (OutputStream)response.getOutputStream());
                    break;
                }
                case 1: {
                    DebugDispatcherServlet.resolveJsonView(response, result);
                    break;
                }
                case 6: {
                    this.resolveModelAndView(request, response, (ModelAndView)result);
                    break;
                }
                case 0: {
                    Object attribute = request.getAttribute("MODELANDVIEW");
                    if (attribute == null) break;
                    this.resolveModelAndView(request, response, (ModelAndView)attribute);
                    break;
                }
                case 7: {
                    DebugDispatcherServlet.resolveObject(request, response, result, this.getViewResolver(), this.getDownloadFileBuf());
                }
            }
            this.log.debug("Process [{}] takes: [{}]ms, with result: [{}]", new Object[]{requestURI, System.currentTimeMillis() - start, result});
        }
        catch (Throwable exception) {
            try {
                exception = ExceptionUtils.unwrapThrowable((Throwable)exception);
                this.getExceptionResolver().resolveException(request, response, exception, requestMapping);
                this.log("Catch Throwable: [" + exception + "] With Msg: [" + exception.getMessage() + "]", exception);
            }
            catch (Throwable e) {
                this.log("Handling of [" + exception.getClass().getName() + "]  resulted in Exception: [" + e.getClass().getName() + "]", e);
                throw new ServletException(e);
            }
        }
    }
}

