/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.resolver;

import cn.taketoday.context.annotation.Singleton;
import cn.taketoday.context.exception.ConversionException;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.web.annotation.ResponseStatus;
import cn.taketoday.web.annotation.WebDebugMode;
import cn.taketoday.web.exception.AccessForbiddenException;
import cn.taketoday.web.exception.BadRequestException;
import cn.taketoday.web.exception.FileSizeExceededException;
import cn.taketoday.web.exception.MethodNotAllowedException;
import cn.taketoday.web.exception.NotFoundException;
import cn.taketoday.web.mapping.HandlerMapping;
import cn.taketoday.web.mapping.HandlerMethod;
import cn.taketoday.web.resolver.ExceptionResolver;
import cn.taketoday.web.utils.Json;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebDebugMode
@Singleton(value={"exceptionResolver"})
public class DefaultExceptionResolver
implements ExceptionResolver {
    private final Logger log = LoggerFactory.getLogger(DefaultExceptionResolver.class);

    @Override
    public void resolveException(HttpServletRequest request, HttpServletResponse response, Throwable ex, HandlerMapping handlerMapping) throws Throwable {
        try {
            response.reset();
            if (handlerMapping != null) {
                HandlerMethod handlerMethod = handlerMapping.getHandlerMethod();
                Method method = handlerMethod.getMethod();
                ResponseStatus responseStatus = method.getAnnotation(ResponseStatus.class);
                if (responseStatus == null) {
                    responseStatus = method.getDeclaringClass().getAnnotation(ResponseStatus.class);
                }
                int status = 500;
                String msg = ex.getMessage();
                String redirect = null;
                if (responseStatus != null) {
                    msg = responseStatus.msg();
                    status = responseStatus.value();
                    redirect = responseStatus.redirect();
                }
                if (status != 500) {
                    response.setStatus(status);
                }
                switch (handlerMethod.getReutrnType()) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 5: {
                        response.setContentType("application/json;charset=UTF-8");
                        JSON.writeJSONString((Writer)response.getWriter(), (Object)new Json(msg, status, false), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty});
                        break;
                    }
                    case 4: {
                        this.resolveImageException(ex, response, request);
                        break;
                    }
                    case 2: {
                        if (StringUtils.isNotEmpty(redirect)) {
                            response.sendRedirect(request.getContextPath() + redirect);
                            break;
                        }
                        this.resolveViewException(ex, response, request, status, msg);
                    }
                }
            } else {
                this.resolveViewException(ex, response, request, 500, ex.getMessage());
            }
            this.log.error("Catch Throwable: [{}] With Msg: [{}]", new Object[]{ex, ex.getMessage(), ex});
        }
        catch (Throwable handlerException) {
            this.log.error("Handling of [{}] resulted in Exception: [{}]", new Object[]{ex.getClass().getName(), handlerException.getClass().getName(), handlerException});
            throw handlerException;
        }
    }

    private void resolveViewException(Throwable ex, HttpServletResponse response, HttpServletRequest request, int status, String msg) throws IOException {
        if (ex instanceof MethodNotAllowedException) {
            response.sendError(405, msg);
        } else if (ex instanceof BadRequestException || ex instanceof ConversionException || ex instanceof FileSizeExceededException) {
            response.sendError(400, msg);
        } else if (ex instanceof NotFoundException) {
            response.sendError(404, msg);
        } else if (ex instanceof AccessForbiddenException) {
            response.sendError(403, msg);
        } else {
            response.sendError(status, msg);
        }
    }

    private void resolveImageException(Throwable ex, HttpServletResponse response, HttpServletRequest request) throws IOException {
        response.setContentType("image/jpeg");
        String fileName = "/error/500.png";
        if (ex instanceof MethodNotAllowedException) {
            fileName = "/error/405.png";
        } else if (ex instanceof BadRequestException || ex instanceof ConversionException) {
            fileName = "/error/400.png";
        } else if (ex instanceof NotFoundException) {
            fileName = "/error/404.png";
        } else if (ex instanceof AccessForbiddenException) {
            fileName = "/error/403.png";
        }
        ImageIO.write((RenderedImage)ImageIO.read(ClassUtils.getClassLoader().getResource(fileName)), "png", (OutputStream)response.getOutputStream());
    }
}

