/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.resolver;

import cn.taketoday.context.annotation.Autowired;
import cn.taketoday.context.annotation.Singleton;
import cn.taketoday.context.bean.BeanDefinition;
import cn.taketoday.context.conversion.Converter;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.factory.InitializingBean;
import cn.taketoday.context.utils.NumberUtils;
import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.web.Constant;
import cn.taketoday.web.WebApplicationContext;
import cn.taketoday.web.WebApplicationContextAware;
import cn.taketoday.web.annotation.ParameterConverter;
import cn.taketoday.web.annotation.WebDebugMode;
import cn.taketoday.web.exception.BadRequestException;
import cn.taketoday.web.mapping.MethodParameter;
import cn.taketoday.web.multipart.MultipartResolver;
import cn.taketoday.web.resolver.ParameterResolver;
import cn.taketoday.web.ui.ModelAndView;
import cn.taketoday.web.ui.ModelAttributes;
import cn.taketoday.web.ui.RedirectModelAttributes;
import cn.taketoday.web.utils.ParamList;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebDebugMode
@Singleton(value={"parameterResolver"})
public class DebugParameterResolver
implements ParameterResolver,
Constant,
InitializingBean,
WebApplicationContextAware {
    private final Logger log = LoggerFactory.getLogger(DebugParameterResolver.class);
    private ServletContext servletContext;
    @Autowired(value="multipartResolver")
    private MultipartResolver multipartResolver;
    private WebApplicationContext applicationContext;
    private final Map<Class<?>, Converter<String, Object>> supportParameterTypes = new HashMap(8, 1.0f);

    public final void register(Class<?> targetClass, Object converter) {
        this.supportParameterTypes.put(targetClass, (Converter<String, Object>)((Converter)converter));
    }

    public void afterPropertiesSet() throws Exception {
        this.log.info("Loading ParameterConverter Extensions");
        try {
            WebApplicationContext applicationContext = this.applicationContext;
            for (Map.Entry entry : applicationContext.getBeanDefinitionsMap().entrySet()) {
                BeanDefinition beanDefinition = (BeanDefinition)entry.getValue();
                Class beanClass = beanDefinition.getBeanClass();
                ParameterConverter converter = beanClass.getAnnotation(ParameterConverter.class);
                if (converter == null) continue;
                if (!Converter.class.isAssignableFrom(beanClass)) {
                    throw new ConfigurationException("Component: [{}] which annotated '@ParameterConverter' must be a [cn.taketoday.context.conversion.Converter]", new Object[]{entry.getKey()});
                }
                Object singleton = applicationContext.getBean(beanClass);
                Class<?>[] values = converter.value();
                if (values.length != 0 && values[0] != Void.TYPE) {
                    for (Class<?> value : values) {
                        this.register(value, singleton);
                        this.log.info("Mapped ParameterConverter : [{}] -> [{}].", value, (Object)beanClass.getName());
                    }
                    continue;
                }
                Class<?> returnType = beanClass.getMethod("doConvert", String.class).getReturnType();
                if (!this.supportParameterTypes.containsKey(returnType)) {
                    this.register(returnType, singleton);
                }
                this.log.info("Mapped ParameterConverter: [{}] -> [{}].", returnType, (Object)beanClass.getName());
            }
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("The method of {}'s parameter only support [java.lang.String]", new Object[]{"doConvert", e});
        }
        if (this.supportParameterTypes.size() < 1) {
            this.log.info("NO ParameterConverter Found");
        }
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.supportParameterTypes.containsKey(parameter.getParameterClass());
    }

    @Override
    public void resolveParameter(Object[] args, MethodParameter[] parameters, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        this.log.debug("Resolve parameter start");
        for (int i = 0; i < parameters.length; ++i) {
            args[i] = this.setParameter(request, response, parameters[i]);
        }
    }

    private final Object setParameter(HttpServletRequest request, HttpServletResponse response, MethodParameter methodParameter) throws Throwable {
        String methodParameterName = methodParameter.getParameterName();
        if (methodParameter.hasAnnotation()) {
            return this.resolveAnnotationParameter(methodParameterName, request, methodParameter);
        }
        switch (methodParameter.getParameterType()) {
            case 10: {
                return request.getSession();
            }
            case 11: {
                return request.getServletContext();
            }
            case 12: {
                return request;
            }
            case 13: {
                return response;
            }
            case 18: {
                return new ModelAttributes(request);
            }
            case 15: {
                return this.resolveSetParameter(request, methodParameterName, methodParameter);
            }
            case 14: {
                return this.resolveMapParameter(request, methodParameterName, methodParameter);
            }
            case 16: {
                return this.resolveListParameter(request, methodParameterName, methodParameter);
            }
            case 1: {
                return this.resolveArrayParameter(request, methodParameterName, methodParameter);
            }
            case 8: {
                return this.resolveStringParameter(request, methodParameterName, methodParameter);
            }
            case 2: {
                return this.resolveParameter(request, methodParameterName, methodParameter, (Converter<String, Object>)((Converter)Byte::parseByte));
            }
            case 5: {
                return this.resolveParameter(request, methodParameterName, methodParameter, (Converter<String, Object>)((Converter)Long::parseLong));
            }
            case 4: {
                return this.resolveParameter(request, methodParameterName, methodParameter, (Converter<String, Object>)((Converter)Short::parseShort));
            }
            case 7: {
                return this.resolveParameter(request, methodParameterName, methodParameter, (Converter<String, Object>)((Converter)Float::parseFloat));
            }
            case 3: {
                return this.resolveParameter(request, methodParameterName, methodParameter, (Converter<String, Object>)((Converter)Integer::parseInt));
            }
            case 6: {
                return this.resolveParameter(request, methodParameterName, methodParameter, (Converter<String, Object>)((Converter)Double::parseDouble));
            }
            case 9: {
                return this.resolveParameter(request, methodParameterName, methodParameter, (Converter<String, Object>)((Converter)Boolean::parseBoolean));
            }
            case 22: {
                ModelAndView modelAndView = new ModelAndView();
                request.setAttribute("MODELANDVIEW", (Object)modelAndView);
                return modelAndView;
            }
            case 23: {
                RedirectModelAttributes redirectModel = new RedirectModelAttributes();
                request.getSession().setAttribute("REDIRECTMODEL", (Object)redirectModel);
                return redirectModel;
            }
        }
        return this.resolve(request, methodParameter, methodParameterName, methodParameter.getParameterClass());
    }

    private Object resolveParameter(HttpServletRequest request, String methodParameterName, MethodParameter methodParameter, Converter<String, Object> converter) throws BadRequestException {
        String requestParameter = request.getParameter(methodParameterName);
        if (StringUtils.isEmpty((String)requestParameter)) {
            if (methodParameter.isRequired()) {
                throw DebugParameterResolver.newBadRequest(null, methodParameterName, null);
            }
            return converter.doConvert((Object)methodParameter.getDefaultValue());
        }
        return converter.doConvert((Object)requestParameter);
    }

    static BadRequestException newBadRequest(String type, String methodParameterName, Throwable ex) {
        StringBuilder msg = new StringBuilder(64);
        if (StringUtils.isNotEmpty((String)type)) {
            msg.append(type);
        } else {
            msg.append("Parameter");
        }
        msg.append(": [").append(methodParameterName).append("] is required and it can't be resolve, bad request.");
        return new BadRequestException(msg.toString(), ex);
    }

    private Object resolveStringParameter(HttpServletRequest request, String methodParameterName, MethodParameter methodParameter) throws BadRequestException {
        String requestParameter = request.getParameter(methodParameterName);
        if (StringUtils.isEmpty((String)requestParameter)) {
            if (methodParameter.isRequired()) {
                throw DebugParameterResolver.newBadRequest(null, methodParameterName, null);
            }
            return methodParameter.getDefaultValue();
        }
        return requestParameter;
    }

    private Object resolveArrayParameter(HttpServletRequest request, String methodParameterName, MethodParameter methodParameter) throws BadRequestException {
        String[] parameterValues = request.getParameterValues(methodParameterName);
        if (parameterValues == null || parameterValues.length == 0) {
            if (methodParameter.isRequired()) {
                throw DebugParameterResolver.newBadRequest(null, methodParameterName, null);
            }
            return null;
        }
        return NumberUtils.parseArray((String[])parameterValues, methodParameter.getParameterClass());
    }

    private final Object resolve(HttpServletRequest request, MethodParameter methodParameter, String methodParameterName, Class<?> parameterClass) throws Throwable {
        if (this.supportsParameter(methodParameter)) {
            this.log.debug("Resolve custom parameter: [{}]", (Object)methodParameterName);
            return this.supportParameterTypes.get(methodParameter.getParameterClass()).doConvert((Object)request.getParameter(methodParameterName));
        }
        Object newInstance = null;
        try {
            newInstance = parameterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw DebugParameterResolver.newBadRequest("Can't resolve pojo", methodParameterName, null);
        }
        this.log.debug("Resolve pojo parameter: [{}]", (Object)methodParameterName);
        if (!this.setBean(request, parameterClass, newInstance, request.getParameterNames(), methodParameter)) {
            throw DebugParameterResolver.newBadRequest("Can't resolve pojo", methodParameterName, null);
        }
        return newInstance;
    }

    private final Object resolveAnnotationParameter(String methodParameterName, HttpServletRequest request, MethodParameter methodParameter) throws Throwable {
        this.log.debug("Resolve Annotation Parameter: [{}]", (Object)methodParameterName);
        switch (methodParameter.getAnnotation()) {
            case 1: {
                return this.cookie(request, methodParameterName, methodParameter);
            }
            case 2: {
                return request.getSession().getAttribute(methodParameterName);
            }
            case 6: {
                try {
                    if (this.multipartResolver.isMultipart(request)) {
                        Object object = this.multipartResolver.resolveMultipart(request, methodParameterName, methodParameter);
                        return object;
                    }
                    throw new BadRequestException("This isn't multipart request, bad request.");
                }
                finally {
                    this.multipartResolver.cleanupMultipart(request);
                }
            }
            case 3: {
                String header = request.getHeader(methodParameterName);
                if (StringUtils.isEmpty((String)header)) {
                    if (methodParameter.isRequired()) {
                        throw DebugParameterResolver.newBadRequest("Header", methodParameterName, null);
                    }
                    return methodParameter.getDefaultValue();
                }
                return header;
            }
            case 4: {
                return this.pathVariable(request, methodParameterName, methodParameter);
            }
            case 7: {
                this.log.debug("Resolve request body: [{}]", (Object)methodParameterName);
                Object requestBody = request.getAttribute("REQUESTBODY");
                if (requestBody != null) {
                    return ((JSONObject)requestBody).getObject(methodParameterName, methodParameter.getParameterClass());
                }
                try {
                    String readLine = request.getReader().readLine();
                    if (readLine == null) {
                        throw DebugParameterResolver.newBadRequest("Request body", methodParameterName, null);
                    }
                    JSONObject object = JSON.parseObject((String)readLine);
                    request.setAttribute("REQUESTBODY", (Object)object);
                    return object.getObject(methodParameterName, methodParameter.getParameterClass());
                }
                catch (IOException e) {
                    throw DebugParameterResolver.newBadRequest("Request body", methodParameterName, e);
                }
            }
            case 5: {
                return this.servletContext.getAttribute(methodParameterName);
            }
        }
        return null;
    }

    private Object pathVariable(HttpServletRequest request, String methodParameterName, MethodParameter methodParameter) throws BadRequestException {
        try {
            String pathVariable;
            Object attribute = request.getAttribute("REPLACED");
            if (attribute == null) {
                String requestURI = (String)request.getAttribute("REQUESTURI");
                this.log.debug("Resolve Path variable: [{}], With request Uri: [{}]", (Object)methodParameterName, (Object)requestURI);
                for (String regex : methodParameter.getSplitMethodUrl()) {
                    this.log.debug("replace: [{}]", (Object)regex);
                    requestURI = requestURI.replace(regex, "\\");
                    this.log.debug("replaced: [{}]", (Object)requestURI);
                }
                String[] split = requestURI.split("\\\\");
                request.setAttribute("REPLACED", (Object)split);
                pathVariable = split[methodParameter.getPathIndex()];
            } else {
                pathVariable = ((String[])attribute)[methodParameter.getPathIndex()];
            }
            this.log.debug("value: [{}]", (Object)pathVariable);
            switch (methodParameter.getParameterType()) {
                case 8: {
                    return pathVariable;
                }
                case 2: {
                    return Byte.parseByte(pathVariable);
                }
                case 3: {
                    return Integer.parseInt(pathVariable);
                }
                case 4: {
                    return Short.parseShort(pathVariable);
                }
                case 5: {
                    return Long.parseLong(pathVariable);
                }
                case 6: {
                    return Double.parseDouble(pathVariable);
                }
                case 7: {
                    return Float.valueOf(Float.parseFloat(pathVariable));
                }
            }
            if (this.supportsParameter(methodParameter)) {
                return this.supportParameterTypes.get(methodParameter.getParameterClass()).doConvert((Object)pathVariable);
            }
        }
        catch (Throwable e) {
            throw DebugParameterResolver.newBadRequest("Path variable", methodParameterName, e);
        }
        throw DebugParameterResolver.newBadRequest("Path variable", methodParameterName, null);
    }

    private final Object cookie(HttpServletRequest request, String methodParameterName, MethodParameter methodParameter) throws BadRequestException {
        this.log.debug("Resolve Cookie: [{}]", (Object)methodParameterName);
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!methodParameterName.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        if (methodParameter.isRequired()) {
            throw DebugParameterResolver.newBadRequest("Cookie", methodParameterName, null);
        }
        return methodParameter.getDefaultValue();
    }

    private boolean setBean(HttpServletRequest request, Class<?> parameterClass, Object bean, Enumeration<String> parameterNames, MethodParameter methodParameter) throws Throwable {
        this.log.debug("Resolve Pojo: [{}]", (Object)parameterClass.getName());
        try {
            while (parameterNames.hasMoreElements()) {
                String parameterName = parameterNames.nextElement();
                if (this.resolvePojoParameter(request, parameterName, bean, parameterClass.getDeclaredField(parameterName), methodParameter)) continue;
                return false;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return true;
    }

    private boolean resolvePojoParameter(HttpServletRequest request, String parameterName, Object bean, Field field, MethodParameter methodParameter) throws Throwable {
        Object property = null;
        Class<?> type = field.getType();
        if (type.isArray()) {
            property = NumberUtils.toArrayObject((String[])request.getParameterValues(parameterName), type);
        } else {
            String parameter = request.getParameter(parameterName);
            if (StringUtils.isEmpty((String)parameter)) {
                return true;
            }
            if (NumberUtils.isNumber(type)) {
                property = NumberUtils.parseDigit((String)parameter, type);
            } else if (type == String.class) {
                property = parameter;
            } else {
                Converter<String, Object> converter = this.supportParameterTypes.get(type);
                if (converter != null) {
                    property = converter.doConvert((Object)parameter);
                } else {
                    throw new BadRequestException("Parameter: [" + parameterName + "] not supported, bad request.");
                }
            }
        }
        if (property == null) {
            return true;
        }
        field.setAccessible(true);
        field.set(bean, property);
        return true;
    }

    private List<?> resolveListParameter(HttpServletRequest request, String parameterName, MethodParameter methodParameter) throws Throwable {
        this.log.debug("Resolve List Parameter: [{}]", (Object)parameterName);
        if (methodParameter.isRequestBody()) {
            this.log.debug("List parameter is request body");
            Object requestBody = request.getAttribute("REQUESTBODY");
            if (requestBody != null) {
                return JSONArray.parseArray((String)((JSONObject)requestBody).getString(parameterName), methodParameter.getGenericityClass());
            }
            try {
                String readLine = request.getReader().readLine();
                if (readLine == null) {
                    throw DebugParameterResolver.newBadRequest("Request body", parameterName, null);
                }
                JSONObject object = JSON.parseObject((String)readLine);
                request.setAttribute("REQUESTBODY", (Object)object);
                JSONArray.parseArray((String)object.getString(parameterName), methodParameter.getGenericityClass());
            }
            catch (IOException e) {
                throw new BadRequestException("Collection request body: [" + parameterName + "] read error.", e);
            }
        }
        Enumeration parameterNames = request.getParameterNames();
        ParamList list = new ParamList();
        Class<?> clazz = methodParameter.getGenericityClass();
        while (parameterNames.hasMoreElements()) {
            String requestParameter = (String)parameterNames.nextElement();
            if (!requestParameter.startsWith(parameterName)) continue;
            String[] split = requestParameter.split("(\\[|\\]|\\.)");
            int index = Integer.parseInt(split[1]);
            Object newInstance = list.get(index);
            if (newInstance == null) {
                newInstance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (!this.resolvePojoParameter(request, requestParameter, newInstance, clazz.getDeclaredField(split[3]), methodParameter)) {
                return list;
            }
            list.set(index, newInstance);
        }
        return list;
    }

    private final Set<?> resolveSetParameter(HttpServletRequest request, String methodParameterName, MethodParameter methodParameter) throws Throwable {
        this.log.debug("Resolve Set Parameter: [{}]", (Object)methodParameterName);
        return new HashSet(this.resolveListParameter(request, methodParameterName, methodParameter));
    }

    private Map<String, Object> resolveMapParameter(HttpServletRequest request, String methodParameterName, MethodParameter methodParameter) throws Throwable {
        this.log.debug("Resolve Map Parameter: [{}]", (Object)methodParameterName);
        Enumeration parameterNames = request.getParameterNames();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> clazz = methodParameter.getGenericityClass();
        while (parameterNames.hasMoreElements()) {
            String requestParameter = (String)parameterNames.nextElement();
            if (!requestParameter.startsWith(methodParameterName)) continue;
            String[] keyList = requestParameter.split("(\\['|\\']|\\.)");
            String key = keyList[1];
            Object newInstance = map.get(key);
            if (newInstance == null) {
                newInstance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (!this.resolvePojoParameter(request, requestParameter, newInstance, clazz.getDeclaredField(keyList[3]), methodParameter)) {
                return map;
            }
            map.put(key, newInstance);
        }
        return map;
    }

    @Override
    public void setWebApplicationContext(WebApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.servletContext = applicationContext.getServletContext();
    }
}

