/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.multipart;

import cn.taketoday.context.annotation.Singleton;
import cn.taketoday.web.annotation.WebDebugMode;
import cn.taketoday.web.exception.BadRequestException;
import cn.taketoday.web.exception.FileSizeExceededException;
import cn.taketoday.web.mapping.MethodParameter;
import cn.taketoday.web.multipart.AbstractMultipartResolver;
import cn.taketoday.web.multipart.DefaultMultipartFile;
import java.util.ArrayList;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.slf4j.LoggerFactory;

@WebDebugMode
@Singleton(value={"multipartResolver"})
public class DefaultMultipartResolver
extends AbstractMultipartResolver {
    @Override
    public Object resolveMultipart(HttpServletRequest request, String methodParameterName, MethodParameter methodParameter) throws Throwable {
        if (this.maxRequestSize < request.getContentLengthLong()) {
            throw new FileSizeExceededException(this.maxRequestSize, null).setActual(request.getContentLengthLong());
        }
        switch (methodParameter.getParameterType()) {
            case 21: {
                return new DefaultMultipartFile(request.getPart(methodParameterName));
            }
            case 22: {
                HashSet<DefaultMultipartFile> multipartFiles = new HashSet<DefaultMultipartFile>();
                for (Part part : request.getParts()) {
                    if (!methodParameterName.equals(part.getName())) continue;
                    multipartFiles.add(new DefaultMultipartFile(part));
                }
                return multipartFiles.toArray(new DefaultMultipartFile[0]);
            }
            case 36: {
                HashSet<DefaultMultipartFile> multipartFiles = new HashSet<DefaultMultipartFile>();
                for (Part part : request.getParts()) {
                    if (!methodParameterName.equals(part.getName())) continue;
                    multipartFiles.add(new DefaultMultipartFile(part));
                }
                return multipartFiles;
            }
            case 37: {
                ArrayList<DefaultMultipartFile> multipartFiles = new ArrayList<DefaultMultipartFile>();
                for (Part part : request.getParts()) {
                    if (!methodParameterName.equals(part.getName())) continue;
                    multipartFiles.add(new DefaultMultipartFile(part));
                }
                return multipartFiles;
            }
        }
        throw new BadRequestException("Not supported type: [" + methodParameter.getParameterClass() + "]");
    }

    @Override
    public void cleanupMultipart(HttpServletRequest request) {
        try {
            for (Part part : request.getParts()) {
                part.delete();
            }
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(DefaultMultipartResolver.class).error("cleanup cache error", (Throwable)ex);
        }
    }
}

