/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.multipart;

import cn.taketoday.web.exception.BadRequestException;
import cn.taketoday.web.exception.InternalServerException;
import cn.taketoday.web.multipart.MultipartFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.Part;

public class DefaultMultipartFile
implements MultipartFile {
    private final Part part;
    public static final int BUFFER_SIZE = 4096;

    public DefaultMultipartFile(Part part) throws BadRequestException {
        if (part == null) {
            throw new BadRequestException("There isn't a file item, bad request.");
        }
        this.part = part;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.part.getInputStream();
    }

    @Override
    public String getContentType() {
        return this.part.getContentType();
    }

    @Override
    public long getSize() {
        return this.part.getSize();
    }

    @Override
    public String getName() {
        return this.part.getName();
    }

    @Override
    public String getFileName() {
        return this.part.getSubmittedFileName();
    }

    @Override
    public boolean save(File dest) {
        try {
            File parentFile = dest.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            this.part.write(dest.getAbsolutePath());
            return true;
        }
        catch (Exception e) {
            throw new InternalServerException("File: [" + this.getFileName() + "] upload failure.", e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.part.getSize() == 0L;
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] getBytes() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Object getOriginalResource() {
        return this.part;
    }

    @Override
    public void delete() throws IOException {
        this.part.delete();
    }
}

