/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.multipart;

import cn.taketoday.context.factory.InitializingBean;
import cn.taketoday.web.exception.BadRequestException;
import cn.taketoday.web.exception.FileSizeExceededException;
import cn.taketoday.web.mapping.MethodParameter;
import cn.taketoday.web.multipart.AbstractMultipartResolver;
import cn.taketoday.web.multipart.CommonsMultipartFile;
import cn.taketoday.web.multipart.MultipartFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class CommonsMultipartResolver
extends AbstractMultipartResolver
implements InitializingBean {
    private final ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());

    public void afterPropertiesSet() {
        this.servletFileUpload.setHeaderEncoding(this.encoding);
        this.servletFileUpload.setFileSizeMax(this.maxFileSize);
        this.servletFileUpload.setSizeMax(this.maxRequestSize);
    }

    @Override
    public boolean isMultipart(HttpServletRequest request) {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    @Override
    public Object resolveMultipart(HttpServletRequest request, String methodParameterName, MethodParameter methodParameter) throws BadRequestException, FileSizeExceededException {
        try {
            if (this.maxRequestSize < request.getContentLengthLong()) {
                throw new FileSizeExceededException(this.maxRequestSize, null).setActual(request.getContentLengthLong());
            }
            return this.parseFileItems(this.servletFileUpload.parseRequest(request), methodParameterName, methodParameter);
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            throw new FileSizeExceededException(this.maxFileSize, (Throwable)e).setActual(e.getActualSize());
        }
        catch (FileUploadException ex) {
            throw new BadRequestException("Failed to parse multipart servlet request With Msg:[" + ex.getMessage() + "]", ex);
        }
    }

    private Object parseFileItems(List<FileItem> fileItems, String methodParameterName, MethodParameter methodParameter) throws BadRequestException {
        switch (methodParameter.getParameterType()) {
            case 21: {
                for (FileItem fileItem : fileItems) {
                    if (!methodParameterName.equals(fileItem.getFieldName())) continue;
                    return new CommonsMultipartFile(fileItem);
                }
                throw new BadRequestException("There isn't a file item, bad request.");
            }
            case 22: {
                return this.multipartFile(fileItems, new ArrayList<MultipartFile>(), methodParameterName).toArray(new MultipartFile[0]);
            }
            case 36: {
                return this.multipartFile(fileItems, new HashSet<MultipartFile>(), methodParameterName);
            }
            case 37: {
                return this.multipartFile(fileItems, new ArrayList<MultipartFile>(), methodParameterName);
            }
        }
        throw new BadRequestException("Not supported type: [" + methodParameter.getParameterClass() + "]");
    }

    private final Collection<MultipartFile> multipartFile(List<FileItem> fileItems, Collection<MultipartFile> multipartFiles, String methodParameterName) {
        for (FileItem fileItem : fileItems) {
            if (!methodParameterName.equals(fileItem.getFieldName())) continue;
            multipartFiles.add(new CommonsMultipartFile(fileItem));
        }
        return multipartFiles;
    }

    @Override
    public void cleanupMultipart(HttpServletRequest request) {
    }
}

