/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.multipart;

import cn.taketoday.web.exception.InternalServerException;
import cn.taketoday.web.multipart.MultipartFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.FileItem;

public class CommonsMultipartFile
implements MultipartFile {
    private final FileItem fileItem;

    public CommonsMultipartFile(FileItem fileItem) {
        this.fileItem = fileItem;
    }

    public final FileItem getFileItem() {
        return this.fileItem;
    }

    @Override
    public String getName() {
        return this.fileItem.getFieldName();
    }

    @Override
    public String getContentType() {
        return this.fileItem.getContentType();
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0L;
    }

    @Override
    public long getSize() {
        return this.fileItem.getSize();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.fileItem.getInputStream();
    }

    @Override
    public String getFileName() {
        return this.fileItem.getName();
    }

    @Override
    public boolean save(File dest) {
        try {
            File parentFile = dest.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            this.fileItem.write(dest);
            return true;
        }
        catch (Exception e) {
            throw new InternalServerException("File: [" + this.getFileName() + "] upload failure.", e);
        }
    }

    @Override
    public byte[] getBytes() {
        return this.fileItem.get();
    }

    @Override
    public Object getOriginalResource() {
        return this.fileItem;
    }

    @Override
    public void delete() throws IOException {
        this.fileItem.delete();
    }
}

