/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.multipart;

import cn.taketoday.web.multipart.MultipartResolver;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractMultipartResolver
implements MultipartResolver {
    protected String location = System.getProperty("java.io.tmpdir");
    protected String encoding = "UTF-8";
    protected long maxFileSize = 2048000L;
    protected long maxRequestSize = 204800000L;
    protected int fileSizeThreshold = 2048000000;

    @Override
    public boolean isMultipart(HttpServletRequest request) {
        if (!"POST".equals(request.getMethod())) {
            return false;
        }
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith("multipart/");
    }

    public AbstractMultipartResolver setLocation(String location) {
        this.location = location;
        return this;
    }

    public AbstractMultipartResolver setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public AbstractMultipartResolver setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    public AbstractMultipartResolver setMaxRequestSize(long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    public AbstractMultipartResolver setFileSizeThreshold(int fileSizeThreshold) {
        this.fileSizeThreshold = fileSizeThreshold;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public int getFileSizeThreshold() {
        return this.fileSizeThreshold;
    }
}

