/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.mapping;

import cn.taketoday.context.annotation.Singleton;
import cn.taketoday.web.mapping.HandlerMapping;
import cn.taketoday.web.mapping.RegexMapping;
import java.util.Arrays;
import java.util.Map;
import java.util.RandomAccess;

@Singleton(value={"handlerMappingRegistry"})
public class HandlerMappingRegistry
implements RandomAccess {
    private HandlerMapping[] array = new HandlerMapping[0];
    private RegexMapping[] regexMappings;
    private Map<String, Integer> requestMappings;

    public HandlerMappingRegistry setRegexMappings(Map<String, Integer> regexMappings) {
        this.regexMappings = new RegexMapping[regexMappings.size()];
        int i = 0;
        for (Map.Entry<String, Integer> entry : regexMappings.entrySet()) {
            this.regexMappings[i++] = new RegexMapping(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HandlerMappingRegistry setRequestMappings(Map<String, Integer> requestMappings) {
        this.requestMappings = requestMappings;
        return this;
    }

    public final RegexMapping[] getRegexMappings() {
        return this.regexMappings;
    }

    public int size() {
        return this.array.length;
    }

    public final Integer getIndex(String key) {
        return this.requestMappings.get(key);
    }

    public final HandlerMapping get(int index) {
        return this.array[index];
    }

    public int add(HandlerMapping e) {
        for (int i = 0; i < this.array.length; ++i) {
            if (!e.equals(this.array[i])) continue;
            return i;
        }
        HandlerMapping[] newArray = new HandlerMapping[this.array.length + 1];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        newArray[this.array.length] = e;
        this.array = newArray;
        return this.array.length - 1;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

