/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.mapping;

import cn.taketoday.context.annotation.Singleton;
import cn.taketoday.web.interceptor.HandlerInterceptor;
import java.util.Arrays;
import java.util.Objects;
import java.util.RandomAccess;

@Singleton(value={"handlerInterceptorRegistry"})
public class HandlerInterceptorRegistry
implements RandomAccess {
    private HandlerInterceptor[] array = new HandlerInterceptor[0];

    public int size() {
        return this.array.length;
    }

    public int indexOf(Class<HandlerInterceptor> handlerInterceptorClass) {
        if (handlerInterceptorClass == null) {
            for (int i = 0; i < this.array.length; ++i) {
                if (this.array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.array.length; ++i) {
                if (!handlerInterceptorClass.getName().equals(this.array[i].getClass().getName())) continue;
                return i;
            }
        }
        return -1;
    }

    public HandlerInterceptor[] toArray() {
        return this.array;
    }

    public final HandlerInterceptor get(int index) {
        return this.array[index];
    }

    public boolean add(HandlerInterceptor e) {
        Objects.requireNonNull(e, "HandlerInterceptor instance can't be null");
        HandlerInterceptor[] newArray = new HandlerInterceptor[this.array.length + 1];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        newArray[this.array.length] = e;
        this.array = newArray;
        return true;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

