/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.config.initializer;

import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.web.Constant;
import cn.taketoday.web.config.initializer.WebComponentInitializer;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import org.slf4j.LoggerFactory;

public class WebServletInitializer<T extends Servlet>
extends WebComponentInitializer<ServletRegistration.Dynamic> {
    private T servlet;
    private int loadOnStartup = -1;
    private MultipartConfigElement multipartConfig;
    private ServletSecurityElement servletSecurity;

    public WebServletInitializer() {
    }

    public WebServletInitializer(T servlet) {
        this.servlet = servlet;
    }

    public MultipartConfigElement getMultipartConfig() {
        return this.multipartConfig;
    }

    @Override
    protected ServletRegistration.Dynamic addRegistration(ServletContext servletContext) {
        T servlet = this.getServlet();
        if (servlet != null) {
            return servletContext.addServlet(this.getServletName(), servlet);
        }
        return null;
    }

    @Override
    protected void configureRegistration(ServletRegistration.Dynamic registration) {
        LoggerFactory.getLogger(this.getClass()).debug("Configure servlet registration: [{}]", (Object)this);
        super.configureRegistration(registration);
        String[] urlMappings = StringUtils.toStringArray(this.getUrlMappings());
        if (StringUtils.isArrayEmpty((String[])urlMappings)) {
            urlMappings = Constant.DEFAULT_MAPPINGS;
        }
        registration.addMapping(urlMappings);
        registration.setLoadOnStartup(this.loadOnStartup);
        if (this.multipartConfig != null) {
            registration.setMultipartConfig(this.multipartConfig);
        }
        if (this.servletSecurity != null) {
            registration.setServletSecurity(this.servletSecurity);
        }
    }

    public String getServletName() {
        return this.getName();
    }

    public void setServletName(String name) {
        this.setName(name);
    }

    public T getServlet() {
        return this.servlet;
    }

    public String toString() {
        return "{\n\t\"servlet\":\"" + this.servlet + "\",\n\t\"name\":\"" + this.getName() + "\",\n\t\"loadOnStartup\":\"" + this.loadOnStartup + "\",\n\t\"multipartConfig\":\"" + this.multipartConfig + "\",\n\t\"servletSecurity\":\"" + this.servletSecurity + "\",\n\t\"initParameters\":\"" + this.getInitParameters() + "\",\n\t\"order\":\"" + this.getOrder() + "\",\n\t\"urlMappings\":\"" + this.getUrlMappings() + "\",\n\t\"asyncSupported\":\"" + this.isAsyncSupported() + "\"\n}";
    }

    public WebServletInitializer<T> setServlet(T servlet) {
        this.servlet = servlet;
        return this;
    }

    public WebServletInitializer<T> setLoadOnStartup(int loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
        return this;
    }

    public WebServletInitializer<T> setMultipartConfig(MultipartConfigElement multipartConfig) {
        this.multipartConfig = multipartConfig;
        return this;
    }

    public WebServletInitializer<T> setServletSecurity(ServletSecurityElement servletSecurity) {
        this.servletSecurity = servletSecurity;
        return this;
    }

    public int getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public ServletSecurityElement getServletSecurity() {
        return this.servletSecurity;
    }
}

