/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.config.initializer;

import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.web.Constant;
import cn.taketoday.web.config.initializer.WebComponentInitializer;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;

public class WebFilterInitializer<T extends Filter>
extends WebComponentInitializer<FilterRegistration.Dynamic> {
    private T filter;
    private boolean matchAfter;
    private DispatcherType[] dispatcherTypes;
    private Set<String> servletNames = new LinkedHashSet<String>();

    @Override
    protected FilterRegistration.Dynamic addRegistration(ServletContext servletContext) {
        return servletContext.addFilter(this.getFilterName(), this.filter);
    }

    public String getFilterName() {
        return this.filter.getClass().getSimpleName();
    }

    @Override
    protected void configureRegistration(FilterRegistration.Dynamic registration) {
        super.configureRegistration(registration);
        EnumSet<DispatcherType> dispatcherTypes = null;
        if (this.dispatcherTypes == null) {
            dispatcherTypes = EnumSet.of(DispatcherType.REQUEST);
        } else {
            dispatcherTypes = EnumSet.noneOf(DispatcherType.class);
            dispatcherTypes.addAll(Arrays.asList(this.dispatcherTypes));
        }
        Collection<String> urlMappings = this.getUrlMappings();
        if (this.servletNames.isEmpty() && urlMappings.isEmpty()) {
            registration.addMappingForUrlPatterns(dispatcherTypes, this.matchAfter, Constant.DEFAULT_MAPPINGS);
        } else {
            if (!this.servletNames.isEmpty()) {
                registration.addMappingForServletNames(dispatcherTypes, this.matchAfter, StringUtils.toStringArray(this.servletNames));
            }
            if (!urlMappings.isEmpty()) {
                registration.addMappingForUrlPatterns(dispatcherTypes, this.matchAfter, StringUtils.toStringArray(urlMappings));
            }
        }
    }

    public WebFilterInitializer<T> setFilter(T filter) {
        this.filter = filter;
        return this;
    }

    public WebFilterInitializer<T> setMatchAfter(boolean matchAfter) {
        this.matchAfter = matchAfter;
        return this;
    }

    public WebFilterInitializer<T> setDispatcherTypes(DispatcherType[] dispatcherTypes) {
        this.dispatcherTypes = dispatcherTypes;
        return this;
    }

    public WebFilterInitializer<T> setServletNames(Set<String> servletNames) {
        this.servletNames = servletNames;
        return this;
    }

    public T getFilter() {
        return this.filter;
    }

    public boolean isMatchAfter() {
        return this.matchAfter;
    }

    public DispatcherType[] getDispatcherTypes() {
        return this.dispatcherTypes;
    }

    public Set<String> getServletNames() {
        return this.servletNames;
    }
}

