/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.config.initializer;

import cn.taketoday.web.config.initializer.OrderedInitializer;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.Registration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public abstract class WebComponentInitializer<D extends Registration.Dynamic>
implements OrderedInitializer {
    private String name;
    private int order = 0;
    private boolean asyncSupported = true;
    private Set<String> urlMappings = new LinkedHashSet<String>();
    private Map<String, String> initParameters = new LinkedHashMap<String, String>();
    private ServletContext servletContext;

    @Override
    public void onStartup(ServletContext servletContext) throws ServletException {
        this.setServletContext(servletContext);
        D registration = this.addRegistration(servletContext);
        if (registration == null) {
            return;
        }
        this.configureRegistration(registration);
    }

    protected abstract D addRegistration(ServletContext var1);

    protected void configureRegistration(D registration) {
        registration.setAsyncSupported(this.asyncSupported);
        if (!this.initParameters.isEmpty()) {
            registration.setInitParameters(this.initParameters);
        }
    }

    public void setInitParameters(Map<String, String> initParameters) {
        this.initParameters = new LinkedHashMap<String, String>(initParameters);
    }

    public void addInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public void setUrlMappings(Collection<String> urlMappings) {
        Objects.requireNonNull(urlMappings, "UrlMappings must not be null");
        this.urlMappings = new LinkedHashSet<String>(urlMappings);
    }

    public Collection<String> getUrlMappings() {
        return this.urlMappings;
    }

    public void addUrlMappings(String ... urlMappings) {
        Objects.requireNonNull(urlMappings, "UrlMappings must not be null");
        this.urlMappings.addAll(Arrays.asList(urlMappings));
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public WebComponentInitializer<D> setName(String name) {
        this.name = name;
        return this;
    }

    public WebComponentInitializer<D> setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
        return this;
    }

    public WebComponentInitializer<D> setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        return this;
    }
}

