/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.config.initializer;

import cn.taketoday.context.annotation.MissingBean;
import cn.taketoday.web.WebApplicationContext;
import cn.taketoday.web.WebApplicationContextAware;
import cn.taketoday.web.config.initializer.WebServletInitializer;
import cn.taketoday.web.servlet.ViewDispatcher;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MissingBean
public class ViewDispatcherInitializer
extends WebServletInitializer<ViewDispatcher>
implements WebApplicationContextAware {
    private WebApplicationContext applicationContext;

    @Override
    public void setWebApplicationContext(WebApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public ViewDispatcher getServlet() {
        Set<String> urls;
        ViewDispatcher viewDispatcher = (ViewDispatcher)((Object)super.getServlet());
        if (viewDispatcher == null && (urls = ViewDispatcher.getMappings().keySet()).size() > 0) {
            ServletContext servletContext = this.getServletContext();
            if (!this.applicationContext.containsBeanDefinition("viewDispatcher")) {
                this.applicationContext.registerBean("viewDispatcher", ViewDispatcher.class);
            }
            viewDispatcher = (ViewDispatcher)((Object)this.applicationContext.getBean("viewDispatcher", ViewDispatcher.class));
            String contextPath = servletContext.getContextPath();
            this.setUrlMappings(urls.stream().map(ac -> ac.replaceFirst(contextPath, "")).collect(Collectors.toSet()));
            Logger log = LoggerFactory.getLogger(ViewDispatcherInitializer.class);
            log.info("Register View Dispatcher Servlet: [{}] With Url Mappings: {}", (Object)viewDispatcher, this.getUrlMappings());
            this.setServletName("viewDispatcher");
            this.setServlet(viewDispatcher);
        }
        return viewDispatcher;
    }

    @Override
    public int getOrder() {
        return -100;
    }
}

