/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.web.config.initializer;

import cn.taketoday.context.annotation.MissingBean;
import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.web.WebApplicationContext;
import cn.taketoday.web.WebApplicationContextAware;
import cn.taketoday.web.config.initializer.WebServletInitializer;
import cn.taketoday.web.multipart.AbstractMultipartResolver;
import cn.taketoday.web.multipart.MultipartResolver;
import cn.taketoday.web.servlet.DispatcherServlet;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletSecurityElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MissingBean
public class DispatcherServletInitializer
extends WebServletInitializer<DispatcherServlet>
implements WebApplicationContextAware {
    private WebApplicationContext applicationContext;
    private String dispatcherServletMapping = "/*";

    @Override
    public void setWebApplicationContext(WebApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public DispatcherServlet getServlet() {
        DispatcherServlet dispatcherServlet = (DispatcherServlet)super.getServlet();
        if (dispatcherServlet == null) {
            this.multipartConfig();
            this.addUrlMappings(StringUtils.split((String)this.dispatcherServletMapping));
            if (!this.applicationContext.containsBeanDefinition("dispatcherServlet")) {
                this.applicationContext.registerBean("dispatcherServlet", DispatcherServlet.class);
            }
            dispatcherServlet = (DispatcherServlet)this.applicationContext.getBean("dispatcherServlet", DispatcherServlet.class);
            Logger log = LoggerFactory.getLogger(DispatcherServletInitializer.class);
            log.info("Register Dispatcher Servlet: [{}] With Url Mappings: {}", (Object)dispatcherServlet, this.getUrlMappings());
            this.setServletName("dispatcherServlet");
            this.setServlet(dispatcherServlet);
        }
        return dispatcherServlet;
    }

    private void multipartConfig() {
        MultipartResolver multipartResolver = (MultipartResolver)this.applicationContext.getBean("multipartResolver", MultipartResolver.class);
        MultipartConfigElement multipartConfig = (MultipartConfigElement)this.applicationContext.getBean("multipartConfig", MultipartConfigElement.class);
        if (multipartConfig != null) {
            this.setMultipartConfig(multipartConfig);
        } else if (multipartResolver instanceof AbstractMultipartResolver) {
            AbstractMultipartResolver abstractMultipartResolver = (AbstractMultipartResolver)multipartResolver;
            multipartConfig = new MultipartConfigElement(abstractMultipartResolver.getLocation(), abstractMultipartResolver.getMaxFileSize(), abstractMultipartResolver.getMaxRequestSize(), abstractMultipartResolver.getFileSizeThreshold());
            this.setMultipartConfig(multipartConfig);
        }
        ServletSecurityElement securityConfig = (ServletSecurityElement)this.applicationContext.getBean("servletSecurity", ServletSecurityElement.class);
        if (securityConfig != null) {
            this.setServletSecurity(securityConfig);
        }
    }

    @Override
    public int getOrder() {
        return 1073741723;
    }

    public DispatcherServletInitializer setApplicationContext(WebApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }

    public DispatcherServletInitializer setDispatcherServletMapping(String dispatcherServletMapping) {
        this.dispatcherServletMapping = dispatcherServletMapping;
        return this;
    }

    public WebApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public String getDispatcherServletMapping() {
        return this.dispatcherServletMapping;
    }
}

